<!doctype html>
<html class="no-js" lang="zxx">
<head>
<meta charset="utf-8">
<meta http-equiv="x-ua-compatible" content="ie=edge">
<title>NWP ENGINEERING DEPARTMENT - SRI LANKA</title>
<meta name="description" content="">
<meta name="viewport" content="width=device-width, initial-scale=1">
<!-- Favicon -->
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="icon" href="images/favicon.ico" type="image/x-icon">
<!-- Google Fonts -->
<link href="css/fonts.css" rel="stylesheet">
<!-- Bootstrap-->
<link rel="stylesheet" href="css/assets/bootstrap.min.css">
<!-- Fontawesome Icon -->
<link rel="stylesheet" href="css/assets/font-awesome.min.css">
<!-- Animate CSS -->
<link rel="stylesheet" href="css/assets/animate.css">
<!-- Mean Menu -->
<link rel="stylesheet" href="css/assets/meanmenu.min.css">
<!-- Owl Carousel -->
<link rel="stylesheet" href="css/assets/owl.carousel.min.css">
<!-- Magnific Popup -->
<link rel="stylesheet" href="css/assets/magnific-popup.css">
<!-- Custom Style -->
<link rel="stylesheet" href="css/assets/normalize.css">
<link rel="stylesheet" href="css/style.css">
<link rel="stylesheet" href="css/assets/responsive.css">
<link rel="stylesheet" href="pagination/public/css/zebra_pagination.css">
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-69018766-3"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-69018766-3');
</script>
</head>
<body>
<!-- Pre-Loader -->
<div id="page-preloader"><span class="spinner"></span></div>
<!-- End Pre-Loader --> 

<!-- Top Bar -->
<?php 
include 'common/top-bar.php';
include 'common/mobile-menu.php';
?>
<!-- End Top Bar --> 

<!-- Page Heading -->
<section class="p-heading text-center">
  <div class="container">
    <div class="page-bg">
      <div class="row">
        <div class="col-md-12">
          <div class="p-content">
            <h4><?php if($lang == 1) { ?> NEWS AND EVENTS <?php } if($lang == 2) { ?> පුවත් සහ සිදුවීම් <?php } if($lang == 3) { ?> செய்திகளும் நிகழ்வூகளும் <?php } ?></h4>
            <ul class="list-unstyled list-inline">
              <li class="list-inline-item"><a href="home"><?php if($lang == 1) { ?> Home <?php } if($lang == 2) { ?> මුල් පිටුව <?php } if($lang == 3) { ?> முகப்பு <?php } ?></a></li>
              <li class="list-inline-item"><i class="fa fa-long-arrow-right" aria-hidden="true"></i><?php if($lang == 1) { ?> News <?php } if($lang == 2) { ?> පුවත් <?php } if($lang == 3) { ?> செய்திகள் <?php } ?></li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- End Page Heading -->

<section class="catagory">
  <div class="container">
    <div class="row">
      <div class="col-lg-3 col-sm-4 hidden-xs">
	  <?php include 'common/common-sidebar.php'; ?>
      </div>
      <div class="col-lg-9 col-sm-8">
        <?php
		$records_per_page = 8;
		require 'pagination/pagination.php';
		$pagination = new Pagination();	
		
		$sql_news = "
			SELECT
				SQL_CALC_FOUND_ROWS
				title, description, img, DATE_FORMAT(date, '%M %d %Y') AS date, group_id
			FROM
				news
			WHERE 
				lang='$lang' AND del=0 
			ORDER BY 
				id DESC, group_id ASC
			LIMIT
				" . (($pagination->get_page() - 1) * $records_per_page) . ', ' . $records_per_page . '
		';
		
		if (!($result_news = @mysqli_query($conn, $sql_news))) {
			die(mysqli_error($conn));
		}
		$rows = mysqli_fetch_assoc(mysqli_query($conn, 'SELECT FOUND_ROWS() AS rows'));
		$pagination->records($rows['rows']);
		$pagination->records_per_page($records_per_page);		

		while($row_news = mysqli_fetch_array($result_news)) { $group_id = $row_news['group_id']; ?>
        <div class="row">
        	<div class="col-md-12">
                <div class="catagory-content">
                  <div class="cat-img"> 
                    <div >
                        <a href="news-details?gid=<?php echo $group_id; ?>"><img src="backend/upload/news/<?php echo $row_news['img']; ?>" alt="" style="height:170px; width:260px; overflow:hidden"></a>
                    </div> 
                  </div>
                  <div class="img-content">
                    <h6><a href="news-details?gid=<?php echo $group_id; ?>"><?php $lim = 120; $title = $row_news['title']; 
                    if (strlen($title) > $lim) $title = substr($title, 0, strrpos(substr($title, 0, $lim), ' ')) . '...'; echo $title; ?></a></h6>
                    
                    <ul class="list-unstyled list-inline">
                      <li class="list-inline-item"><?php echo $row_news['date']; ?></li>
                    </ul>
                    
                    <p><?php  $limit = 300;
                    $des = $row_news['description']; 
                    if (strlen($des) > $limit) $des = substr($des, 0, strrpos(substr($des, 0, $limit), ' ')) . '...'; echo $des; ?></p>
                  </div>
                </div>
            </div>
        </div>
        <?php } ?>
        
		<div class="row">
        	<div class="col-lg-12">
			<?php // render the pagination links
            $pagination->render(); ?>
            </div>
        </div>
        
      </div>
    </div>
  </div>
</section>

<!-- Footer -->
<?php include 'common/footer.php'; ?>
<!-- End Footer --> 

<!-- =========================================
JavaScript Files
========================================== --> 

<!-- jQuery JS --> 
<script src="js/assets/vendor/jquery-1.12.4.min.js"></script> 
<!-- Poppers Js --> 
<script src="js/assets/popper.js"></script> 
<!-- Bootstrap --> 
<script src="js/assets/bootstrap.min.js"></script> 
<!-- Sticky Js --> 
<script src="js/assets/jquery.sticky.js"></script> 
<!-- WOW JS --> 
<script src="js/assets/wow.min.js"></script> 
<!-- Smooth Scroll --> 
<script src="js/assets/smooth-scroll.js"></script> 
<!-- Mean Menu --> 
<script src="js/assets/jquery.meanmenu.min.js"></script> 
<!-- News Ticker --> 
<script src="js/assets/jquery.newsticker.min.js"></script> 
<!-- Owl Carousel --> 
<script src="js/assets/owl.carousel.min.js"></script> 
<!-- Magnific Popup --> 
<script src="js/assets/jquery.magnific-popup.min.js"></script> 
<!-- Syotimer --> 
<script src="js/assets/jquery.syotimer.min.js"></script> 
<!-- Custom JS --> 
<script src="js/plugins.js"></script> 
<script src="js/custom.js"></script> 
<!-- Vertical Nav Bar --> 
<script src="js/nav-bar/menu.min.js"></script> 

<script type="text/javascript" src="pagination/public/javascript/zebra_pagination.js"></script>

<!-- JavaScript Validation For Login Page -->
<script src="js/assets/jquery.validate.min.js"></script>
<script src="js/form_validate.js"></script>'

<script>
$(function() {
  $('#auto-collapse-menu-demo').metisMenu();
});
</script>
</body>
</html>