(function(root,factory){if(typeof define==='function'&&define.amd){define([],factory(root));}else if(typeof exports==='object'){module.exports=factory(root);}else{root.smoothScroll=factory(root);}})(typeof global!=='undefined'?global:this.window||this.global,(function(root){'use strict';var smoothScroll={};var supports='querySelector'in document&&'addEventListener'in root;var settings,anchor,toggle,fixedHeader,headerHeight,eventTimeout,animationInterval;var defaults={selector:'[data-scroll]',selectorHeader:null,speed:600,easing:'easeInQuint',offset:0,callback:function(){}};var extend=function(){var extended={};var deep=false;var i=0;var length=arguments.length;if(Object.prototype.toString.call(arguments[0])==='[object Boolean]'){deep=arguments[0];i++;}
var merge=function(obj){for(var prop in obj){if(Object.prototype.hasOwnProperty.call(obj,prop)){if(deep&&Object.prototype.toString.call(obj[prop])==='[object Object]'){extended[prop]=extend(true,extended[prop],obj[prop]);}else{extended[prop]=obj[prop];}}}};for(;i<length;i++){var obj=arguments[i];merge(obj);}
return extended;};var getHeight=function(elem){return Math.max(elem.scrollHeight,elem.offsetHeight,elem.clientHeight);};var getClosest=function(elem,selector){var firstChar=selector.charAt(0);var supports='classList'in document.documentElement;var attribute,value;if(firstChar==='['){selector=selector.substr(1,selector.length-2);attribute=selector.split('=');if(attribute.length>1){value=true;attribute[1]=attribute[1].replace(/"/g,'').replace(/'/g,'');}}
for(;elem&&elem!==document&&elem.nodeType===1;elem=elem.parentNode){if(firstChar==='.'){if(supports){if(elem.classList.contains(selector.substr(1))){return elem;}}else{if(new RegExp('(^|\\s)'+selector.substr(1)+'(\\s|$)').test(elem.className)){return elem;}}}
if(firstChar==='#'){if(elem.id===selector.substr(1)){return elem;}}
if(firstChar==='['){if(elem.hasAttribute(attribute[0])){if(value){if(elem.getAttribute(attribute[0])===attribute[1]){return elem;}}else{return elem;}}}
if(elem.tagName.toLowerCase()===selector){return elem;}}
return null;};var escapeCharacters=function(id){if(id.charAt(0)==='#'){id=id.substr(1);}
var string=String(id);var length=string.length;var index=-1;var codeUnit;var result='';var firstCodeUnit=string.charCodeAt(0);while(++index<length){codeUnit=string.charCodeAt(index);if(codeUnit===0x0000){throw new InvalidCharacterError('Invalid character: the input contains U+0000.');}
if((codeUnit>=0x0001&&codeUnit<=0x001F)||codeUnit==0x007F||(index===0&&codeUnit>=0x0030&&codeUnit<=0x0039)||(index===1&&codeUnit>=0x0030&&codeUnit<=0x0039&&firstCodeUnit===0x002D)){result+='\\'+codeUnit.toString(16)+' ';continue;}
if(codeUnit>=0x0080||codeUnit===0x002D||codeUnit===0x005F||codeUnit>=0x0030&&codeUnit<=0x0039||codeUnit>=0x0041&&codeUnit<=0x005A||codeUnit>=0x0061&&codeUnit<=0x007A){result+=string.charAt(index);continue;}
result+='\\'+string.charAt(index);}
return'#'+result;};var easingPattern=function(type,time){var pattern;if(type==='easeInQuad')pattern=time*time;if(type==='easeOutQuad')pattern=time*(2-time);if(type==='easeInOutQuad')pattern=time<0.5?2*time*time:-1+(4-2*time)*time;if(type==='easeInCubic')pattern=time*time*time;if(type==='easeOutCubic')pattern=(--time)*time*time+1;if(type==='easeInOutCubic')pattern=time<0.5?4*time*time*time:(time-1)*(2*time-2)*(2*time-2)+1;if(type==='easeInQuart')pattern=time*time*time*time;if(type==='easeOutQuart')pattern=1-(--time)*time*time*time;if(type==='easeInOutQuart')pattern=time<0.5?8*time*time*time*time:1-8*(--time)*time*time*time;if(type==='easeInQuint')pattern=time*time*time*time*time;if(type==='easeOutQuint')pattern=1+(--time)*time*time*time*time;if(type==='easeInOutQuint')pattern=time<0.5?16*time*time*time*time*time:1+16*(--time)*time*time*time*time;return pattern||time;};var getEndLocation=function(anchor,headerHeight,offset){var location=0;if(anchor.offsetParent){do{location+=anchor.offsetTop;anchor=anchor.offsetParent;}while(anchor);}
location=Math.max(location-headerHeight-offset,0);return Math.min(location,getDocumentHeight()-getViewportHeight());};var getViewportHeight=function(){return Math.max(document.documentElement.clientHeight,root.innerHeight||0);};var getDocumentHeight=function(){return Math.max(document.body.scrollHeight,document.documentElement.scrollHeight,document.body.offsetHeight,document.documentElement.offsetHeight,document.body.clientHeight,document.documentElement.clientHeight);};var getDataOptions=function(options){return!options||!(typeof JSON==='object'&&typeof JSON.parse==='function')?{}:JSON.parse(options);};var getHeaderHeight=function(header){return!header?0:(getHeight(header)+header.offsetTop);};var adjustFocus=function(anchor,endLocation,isNum){if(isNum)return;anchor.focus();if(document.activeElement.id!==anchor.id){anchor.setAttribute('tabindex','-1');anchor.focus();anchor.style.outline='none';}
root.scrollTo(0,endLocation);};smoothScroll.animateScroll=function(anchor,toggle,options){var overrides=getDataOptions(toggle?toggle.getAttribute('data-options'):null);var animateSettings=extend(settings||defaults,options||{},overrides);var isNum=Object.prototype.toString.call(anchor)==='[object Number]'?true:false;var anchorElem=isNum||!anchor.tagName?null:anchor;if(!isNum&&!anchorElem)return;var startLocation=root.pageYOffset;if(animateSettings.selectorHeader&&!fixedHeader){fixedHeader=document.querySelector(animateSettings.selectorHeader);}
if(!headerHeight){headerHeight=getHeaderHeight(fixedHeader);}
var endLocation=isNum?anchor:getEndLocation(anchorElem,headerHeight,parseInt(animateSettings.offset,10));var distance=endLocation-startLocation;var documentHeight=getDocumentHeight();var timeLapsed=0;var percentage,position;var stopAnimateScroll=function(position,endLocation,animationInterval){var currentLocation=root.pageYOffset;if(position==endLocation||currentLocation==endLocation||((root.innerHeight+currentLocation)>=documentHeight)){clearInterval(animationInterval);adjustFocus(anchor,endLocation,isNum);animateSettings.callback(anchor,toggle);}};var loopAnimateScroll=function(){timeLapsed+=16;percentage=(timeLapsed/parseInt(animateSettings.speed,10));percentage=(percentage>1)?1:percentage;position=startLocation+(distance*easingPattern(animateSettings.easing,percentage));root.scrollTo(0,Math.floor(position));stopAnimateScroll(position,endLocation,animationInterval);};var startAnimateScroll=function(){clearInterval(animationInterval);animationInterval=setInterval(loopAnimateScroll,16);};if(root.pageYOffset===0){root.scrollTo(0,0);}
startAnimateScroll();};var hashChangeHandler=function(event){var hash=root.location.hash;if(!anchor)return;anchor.id=anchor.getAttribute('data-scroll-id');smoothScroll.animateScroll(anchor,toggle);anchor=null;toggle=null;};var clickHandler=function(event){if(event.button!==0||event.metaKey||event.ctrlKey)return;toggle=getClosest(event.target,settings.selector);if(!toggle||toggle.tagName.toLowerCase()!=='a')return;if(toggle.hostname!==root.location.hostname||toggle.pathname!==root.location.pathname||!/#/.test(toggle.href))return;var hash=escapeCharacters(toggle.hash);if(hash==='#'){event.preventDefault();anchor=document.body;var id=anchor.id?anchor.id:'smooth-scroll-top';anchor.setAttribute('data-scroll-id',id);anchor.id='';if(root.location.hash.substring(1)===id){hashChangeHandler();}else{root.location.hash=id;}
return;}
anchor=document.querySelector(hash);if(!anchor)return;anchor.setAttribute('data-scroll-id',anchor.id);anchor.id='';if(toggle.hash===root.location.hash){event.preventDefault();hashChangeHandler();}};var resizeThrottler=function(event){if(!eventTimeout){eventTimeout=setTimeout((function(){eventTimeout=null;headerHeight=getHeaderHeight(fixedHeader);}),66);}};smoothScroll.destroy=function(){if(!settings)return;document.removeEventListener('click',clickHandler,false);root.removeEventListener('resize',resizeThrottler,false);settings=null;anchor=null;toggle=null;fixedHeader=null;headerHeight=null;eventTimeout=null;animationInterval=null;};smoothScroll.init=function(options){if(!supports)return;smoothScroll.destroy();settings=extend(defaults,options||{});fixedHeader=settings.selectorHeader?document.querySelector(settings.selectorHeader):null;headerHeight=getHeaderHeight(fixedHeader);document.addEventListener('click',clickHandler,false);root.addEventListener('hashchange',hashChangeHandler,false);if(fixedHeader){root.addEventListener('resize',resizeThrottler,false);}};return smoothScroll;}));