<!DOCTYPE html>
<html class="no-js" lang="zxx">
<head>
<meta charset="utf-8">
<meta http-equiv="x-ua-compatible" content="ie=edge">
<title>NWP ENGINEERING DEPARTMENT - SRI LANKA</title>
<meta name="description" content="">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="keywords" content="NWP Engineering Department, NWP Eng, North Western Province Engineering Department, North Western Province Engineering Department Sri Lanka, NWPED, NWPED Sri Lanka, North Western Province, Kurunegala, NWP Engineering Department Sri Lanka, Engineering Consultancy Agency, Government Sri Lanka, Engineering Department" />
<meta name="description" content="NWP Engineering Department is the North Western Province's premier engineering consultancy agency in construction of buildings and water resources development, particularly in the field of irrigation. A Provincial government enterprise specializing in engineering consultancy services, it was established in 1989. Provincial Engineering Department as a provincial organization aims primarily to conduct a general business of consultancy management and specialty service for the investigations survey study, planning and consulting of buildings irrigation projects and related water resources development undertakings either alone or jointly with other corporations or entities. It also aims to provide technical assistance in agricultural institutional and man power development, operation and maintenance of irrigation systems and various specialty services." />
<meta property="og:type" content="Engineering Consultancy Agency" />
<meta property="og:title" content="NWP Engineering Department" />
<meta property="og:url" content="https://www.engdept.nw.gov.lk/" />
<meta property="og:image" content="https://www.engdept.nw.gov.lk/images/logo.png" />
<!-- Favicon -->
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="icon" href="images/favicon.ico" type="image/x-icon">
<!-- Google Fonts -->
<link href="css/fonts.css" rel="stylesheet">
<!-- Bootstrap -->
<link rel="stylesheet" href="css/assets/bootstrap.min.css">
<!-- Fontawesome Icon -->
<link rel="stylesheet" href="css/assets/font-awesome.min.css">
<!-- Animate CSS -->
<link rel="stylesheet" href="css/assets/animate.css">
<!-- Mean Menu -->
<link rel="stylesheet" href="css/assets/meanmenu.min.css">
<!-- Owl Carousel -->
<link rel="stylesheet" href="css/assets/owl.carousel.min.css">
<!-- Magnific Popup -->
<link rel="stylesheet" href="css/assets/magnific-popup.css">
<!-- Custom Style -->
<link rel="stylesheet" href="css/assets/normalize.css">
<link rel="stylesheet" href="css/style.css">
<link rel="stylesheet" href="css/assets/responsive.css">
<!-- Vertical Nav Bar -->
<link rel="stylesheet" href="css/nav-bar/menu.min.css">
<link rel="stylesheet" href="css/nav-bar/menu.css">
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-69018766-3"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-69018766-3');
</script>
<style>
#login-form input{
	margin-bottom: 0 !important;
}
.help-block {
    color: #d32f2f;
    font-size: 12px;
}
</style>
</head>
<body>
<!-- Pre-Loader -->
<div id="page-preloader"><span class="spinner"></span></div>
<!-- End Pre-Loader --> 

<!-- Top Bar -->
<?php 
include 'common/top-bar.php';
include 'common/mobile-menu.php';

$sql_bn = mysqli_query($conn, "SELECT * FROM side_banners");
if(mysqli_num_rows($sql_bn) == 0) {
	$banner_1 = $banner_2 = '';
  
} else {
	$row_bn = mysqli_fetch_assoc($sql_bn);
	$banner_1 = $row_bn['banner_1'];
	$banner_2 = $row_bn['banner_2'];
}
?>

<!-- End Top Bar --> 

<!-- Web Ticker -->
<section class="top-news hidden-xs">
  <div class="container">
    <div class="news-content">
      <div class="row">
        <div class="col-lg-12">
          <div class="ticker d-flex justify-content-between">
            <div class="news-head"> <span>
              <?php if($lang == 1) { ?>
              LATEST NEWS
              <?php } if($lang == 2) { ?>
              නවතම ප්‍රවෘත්ති
              <?php } if($lang == 3) { ?>
              புதிய செய்தி
              <?php } ?>
              <i class="fa fa-caret-right"></i></span> </div>
            <ul id="webTicker">
              <?php $sql_news = mysqli_query($conn, "SELECT group_id, title FROM news WHERE lang='$lang' AND del=0 ORDER BY id DESC, group_id ASC LIMIT 5");
				while($row_news = mysqli_fetch_array($sql_news)) { ?>
              <li><a href="news-details?gid=<?php echo $row_news['group_id']; ?>"><i class="fa fa-dot-circle-o"></i> <?php echo $row_news['title']; ?></a></li>
              <?php } ?>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- End Web Ticker --> 

<!-- Slider Area -->
<section class="slider-area">
  <div class="container">
    <div class="row">
      <div class="col-lg-3 col-sm-4 hidden-xs" style="padding-right: 5px;">
        <?php include 'common/sidebar-nav.php'; ?>
      </div>
      <div class="col-lg-9 col-sm-8 col-xs-12 padding-fix-l">
        <div class="owl-carousel owl-slider">
          <?php $sql_banner = mysqli_query($conn, "SELECT group_id, img FROM main_banner WHERE del=0 group by group_id ORDER BY id ASC, group_id ASC LIMIT 5");
		  while($row_banner = mysqli_fetch_array($sql_banner)) {
			  $gid = $row_banner['group_id'];
			  $sql_b = mysqli_fetch_assoc(mysqli_query($conn, "SELECT title, description, DATE_FORMAT(date, '%M %d %Y') AS date FROM main_banner WHERE lang='$lang' AND del=0 AND group_id='$gid'")); ?>
          <div class="slider-content"> <img src="backend/upload/main_banner/<?php echo $row_banner['img']; ?>" alt="" class="img-fluid">
            <?php if(!empty($sql_b['title']) || !empty($sql_b['description'])) { ?>
			<div class="slider-layer">
              <p><u><?php echo $sql_b['title']; ?></u></p>
              <p><?php echo $sql_b['description']; ?></p>
              <ul class="list-unstyled list-inline">
                <li class="list-inline-item"><?php echo $sql_b['date']; ?></li>
              </ul>
            </div>
			<?php } ?>
          </div>
          <?php } ?>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- End Slider Area --> 

<!-- All News -->
<section class="allnews">
  <div class="container">
    <div class="row">
      <div class="col-lg-8 col-md-12">
        <div class="vision-div">
          <p align="justify">
            <?php if($lang == 1) { ?>
            <!--PED is a dynamic consulting outfit composed of highly trained and experienced personnel who have distinguished themselves in their respective fields of specialization.   PED is ready to deliver a complete package of engineering expertise and technical know – how throughout the province.  It has the human   resources, technology and equipment to accomplish the needs of the client agencies, whether it involves feasibility studies, conceptual planning & designs, detailed engineering designs either in buildings, irrigation and drainage project or construction development, operation and maintenance of irrigation systems.  Provincial Engineering Department is a partner you can trust on any time.-->
			PED is a dynamic consulting outfit composed of highly trained and experienced personnel who have distinguished themselves in their respective fields of specialization. It has the human resources, technology and equipment to accomplish the needs of the client agencies. PED involves Design, construction, additions & improvements and maintenance of buildings and also provides provision of architectural and engineering consultancy services to the institutions coming under the preview of the North Western Provincial Council. Provincial Engineering Department is a partner you can trust on any time.
            <?php } if($lang == 2) { ?>
            වයඹ පළාත් ඉංජිනේරු දෙපාර්තමේන්තුව යනු විශේෂිත පුහුණුවක් සහිත හා පළපුරුදු පුද්ගලයන්ගෙන් සමන්විත වූ විශේෂඥ ක්ෂේත්‍රයේ කැපී පෙනෙන විශේෂඥයින්ගෙන් සැදුම් ලත් උපදේශාත්මක කට්ටලයකි. පළාත පුරාම ඉංජිනේරු තාක්ෂණික දැනුම හා තාක්ෂණික දැනුම සම්පූර්ණ කිරීම සඳහා වයඹ පළාත් ඉංජිනේරු දෙපාර්තමේන්තුව සූදානම් වේ. ශක්‍යතා සංගණනවල අවශ්‍යතා සපුරා ගැනීම සඳහා මානව සම්පත්, තාක්ෂණය සහ උපකරණ සතුව පවතී. ශක්‍යතා අධ්‍යන, සංකල්පමය සැලසුම්කරණය සහ සැලසුම්, සවිස්තරාත්මක ඉංජිනේරු සැලසුම් ගොඩනැගිලි, වාරිමාර්ග හා ජලාපවහන ව්‍යාපෘතිය හෝ ඉදිකිරීම් සංවර්ධනය, ක්‍රියාත්මක කිරීම හා නඩත්තුව වාරිමාර්ග පද්ධති . ඕනෑම අවස්ථාවක ඔබ විශ්වාස කළ හැකි හවුල්කරු වන පළාත් ඉංජිනේරු දෙපාර්තමේන්තුව.
            <?php } if($lang == 3) { ?>
            வடமேற்கு மாகாண பொறியியல் துறை ஆனது மிகவும் பயிற்சி பெற்ற மற்றும் அனுபவம் வாய்ந்த ஊழியர்களால் இயற்றப்பட்ட ஒரு மாறும் ஆலோசனைக் குழுவாகும், அவர்கள் சிறப்பு அந்தந்த துறைகளில் தங்களை வேறுபடுத்திக் காட்டியுள்ளனர். வடமேற்கு மாகாண பொறியியல் துறை முழுமையான பொறியியலாளர்களின் நிபுணத்துவத்தையும் பொதியினை அறிமுகப்படுத்துவதையும் தயார்படுத்துகிறது. வாடிக்கையாளர் முகவர் அமைப்புகளின் தேவைகளை நிறைவேற்றுவதற்கு மனித வளங்கள், தொழில்நுட்பம் மற்றும் கருவிகள் ஆகியவை உள்ளன. இது சாத்தியமுள்ள ஆய்வுகள், கருத்தாய்வு திட்டமிடல் மற்றும் வடிவமைப்புகள், கட்டிடங்கள், நீர்ப்பாசனம் மற்றும் வடிகால் திட்டம் அல்லது கட்டுமான வளர்ச்சி, அறுவை சிகிச்சை மற்றும் நீர்ப்பாசன முறைகளின் பராமரிப்பு . மாகாண பொறியியல் திணைக்களம் எந்த நேரத்திலும் நீங்கள் நம்பக்கூடிய பங்காளியாகும்.
            <?php } ?>
          </p>
        </div>
        <div class="vision-div">
          <h4>
            <?php if($lang == 1) { ?>
            OUR VISION
            <?php } if($lang == 2) { ?>
            අපගේ දැක්ම
            <?php } if($lang == 3) { ?>
            தூரநோக்கு
            <?php } ?>
          </h4>
          <?php $sql_vission = mysqli_fetch_assoc(mysqli_query($conn, "SELECT vision, mission FROM vision WHERE lang='$lang' AND del=0")); ?>
          <p align="justify"><?php echo $sql_vission['vision']; ?></p>
        </div>
        <div class="mission-div">
          <h4>
            <?php if($lang == 1) { ?>
            OUR MISSION
            <?php } if($lang == 2) { ?>
            අපගේ මෙහෙවර
            <?php } if($lang == 3) { ?>
            பணிக்கூற்று
            <?php } ?>
          </h4>
          <p align="justify"><?php echo $sql_vission['mission']; ?></p>
        </div>
        <div class="latest-top">
          <h4>
            <?php if($lang == 1) { ?>
            LATEST NEWS AND EVENTS
            <?php } if($lang == 2) { ?>
            නවතම පුවත් සහ සිදුවීම්
            <?php } if($lang == 3) { ?>
            புதிய செய்திகளும் நிகழ்வூகனும்
            <?php } ?>
          </h4>
        </div>
        <div class="owl-carousel latest-slider">
          <?php $sql_lt = mysqli_query($conn, "SELECT group_id, title, description, DATE_FORMAT(date, '%M %d %Y') AS date, img FROM news WHERE lang='$lang' AND del=0 ORDER BY id DESC, group_id ASC LIMIT 3");
		  while($row_lt = mysqli_fetch_array($sql_lt)) { $news_id = $row_lt['group_id']; ?>
          <div class="latest-item">
            <div class="row">
              <div class="col-md-7" style="padding-right: 0;">
                <div class="latest-content"><div style="height: 250px; overflow:hidden; margin-bottom:10px"> <img src="backend/upload/news/<?php echo $row_lt['img']; ?>" alt="" class="img-fluid"></div>
                  <h6><a href="news-details?gid=<?php echo $news_id; ?>">
                    <?php $lim = 85; $titl = $row_lt['title']; 
					if (strlen($titl) > $lim) $titl = substr($titl, 0, strrpos(substr($titl, 0, $lim), ' ')) . '...'; echo $titl; ?>
                    </a></h6>
                  <ul class="list-unstyled list-inline">
                    <a href="news-details?gid=<?php echo $news_id; ?>">
                    <li class="list-inline-item"><?php if($lang == 1) { ?>
                    READ MORE
                    <?php } if($lang == 2) { ?>
                    තවදුරටත් කියවන්න
                    <?php } if($lang == 3) { ?>
                    மேலும் வாசிக்க
                    <?php } ?></li>
                    </a>
                    <li class="list-inline-item"><?php echo $row_lt['date']; ?></li>
                  </ul>
                  <p align="justify">
                    <?php $des = $row_lt['description']; if (strlen($des) > 150) $des = substr($des, 0, strrpos(substr($des, 0, 150), ' ')) . '...'; echo $des; ?>
                  </p>
                </div>
              </div>
              <div class="col-md-5 hidden-xs">
                <?php
				$sql_lts = mysqli_query($conn, "SELECT group_id, title, description, DATE_FORMAT(date, '%M %d %Y') AS date, img FROM news WHERE lang='$lang' AND del=0 ORDER BY id DESC, group_id ASC LIMIT 0, 4");
		  while($row_lts = mysqli_fetch_array($sql_lts)) { ?>
                <div class="slider-content">
                  <div class="slider-img"> <a href="news-details?gid=<?php echo $row_lts['group_id']; ?>"><img src="backend/upload/news/<?php echo $row_lts['img']; ?>" alt="" class="img-fluid" style="height:70px; width: 100px; overflow:hidden"></a> </div>
                  <div class="img-content">
                    <p><a href="news-details?gid=<?php echo $row_lts['group_id']; ?>">
                      <?php $news = $row_lts['title']; 
					if (strlen($news) > 55) $news = substr($news, 0, strrpos(substr($news, 0, 55), ' ')) . '...'; echo $news; ?>
                      </a></p>
                    <span><?php echo $row_lts['date']; ?></span> </div>
                </div>
                <?php } ?>
              </div>
            </div>
          </div>
          <?php } ?>
        </div>
        <div class="popular-top">
          <h4>
            <?php if($lang == 1) { ?>
            CONSTRUCTION SITES
            <?php } if($lang == 2) { ?>
            ඉදිකිරීම් ස්ථාන
            <?php } if($lang == 3) { ?>
            கட்டுமான பிரிவூ
            <?php } ?>
          </h4>
        </div>
        <div class="owl-carousel popular-slider">
          <div class="popular-item">
            <div class="row">
              <?php $sql_cons = mysqli_query($conn, "SELECT group_id, title, description, img, DATE_FORMAT(date, '%M %d %Y') AS date FROM construction_sites WHERE lang='$lang' AND del=0 ORDER BY id DESC, group_id ASC LIMIT 3");
              while($row_cons = mysqli_fetch_array($sql_cons)) { ?>
              <div class="col-lg-4 col-md-6" style="padding-right: 0;">
                <div class="slider-content">
                  <div class="slider-img">
                    <div style="height:150px; overflow:hidden"> <a href="construction-sites"><img src="backend/upload/const_sites/<?php echo $row_cons['img']; ?>" alt="" class="img-fluid"></a> </div>
                  </div>
                  <div class="img-content">
                    <ul class="list-unstyled list-inline">
                      <li class="list-inline-item"><?php echo $row_cons['date']; ?></li>
                    </ul>
                    <p><a href="construction-sites">
                      <?php $limit = 55; $title = $row_cons['title']; 
					if (strlen($title) > $limit) $title = substr($title, 0, strrpos(substr($title, 0, $limit), ' ')) . '...'; echo $title; ?>
                      </a></p>
                    <p style="font-size:13px; line-height: 22px;"><?php $des_con = $row_cons['description']; 
					if (strlen($des_con)> 200) $des_con = substr($des_con, 0, strrpos(substr($des_con, 0, 200), ' ')).'...'; echo $des_con; ?></p>
                  </div>
                </div>
              </div>
              <?php } ?>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-4 col-md-12">
        <div class="div-office-widget">
          <h4>
            <?php if($lang == 1) { ?>
            DIVISIONAL OFFICES
            <?php } if($lang == 2) { ?>
            ප්‍රාදේශීය කාර්යාල
            <?php } if($lang == 3) { ?>
            பிரதேச அலுவலங்கள்
            <?php } ?>
          </h4>
          <div class="vertical-menu">
            <?php $sql_div = mysqli_query($conn, "SELECT division FROM divisional_offices WHERE lang='$lang' AND del=0 ORDER BY group_id ASC");
              while($row_div = mysqli_fetch_array($sql_div)) { ?>
            <a href="divisional-engineers#<?php echo $row_div['division']; ?>"><i class="fa fa-angle-double-right"></i> &nbsp;&nbsp;<?php echo $row_div['division']; ?></a>
            <?php } ?>
          </div>
        </div>
        <div class="add-widget">
        <?php if(!empty($banner_1)) { ?>
          <a><img src="backend/upload/side_banners/<?php echo $banner_1; ?>" alt="NWP Engineering Department" class="img-fluid"></a>
        <?php } ?>
		</div>
        <div class="tab-widget"> 
          <!-- Nav tabs -->
          <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item"> <a class="nav-link active" data-toggle="tab" href="#rel_links" role="tab">
              <?php if($lang == 1) { ?>
              RELATED LINKS
              <?php } if($lang == 2) { ?>
              සබැඳි වෙබ් අඩවි
              <?php } if($lang == 3) { ?>
              தொடர்புடைய இணைப்புகள்
              <?php } ?>
              </a> </li>
            <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#pub" role="tab">
              <?php if($lang == 1) { ?>
              PUBLICATIONS
              <?php } if($lang == 2) { ?>
              ප්‍රකාශන
              <?php } if($lang == 3) { ?>
              வெளியீடுகள்
              <?php } ?>
              </a> </li>
          </ul>
          <!-- Tab panes -->
          <div class="tab-content">
            <div class="tab-pane fade show active" id="rel_links" role="tabpanel">
              <?php $sql_link = mysqli_query($conn, "SELECT title, url, logo FROM related_links WHERE lang='$lang' AND del=0 ORDER BY id ASC, group_id ASC");
              while($row_link = mysqli_fetch_array($sql_link)) { ?>
              <div class="m-view-content">
                <?php if(!empty($row_link['logo'])) { ?>
                <div class="m-view-img"> <a href="#"><img src="backend/upload/related_links/<?php echo $row_link['logo']; ?>" alt="" class="img-fluid"></a> </div>
                <?php } ?>
                <div class="img-content">
                  <p><a href="<?php echo $row_link['url']; ?>" target="_blank"><?php echo $row_link['title']; ?></a></p>
                </div>
              </div>
              <?php } ?>
            </div>
            <div class="tab-pane fade" id="pub" role="tabpanel">
              <div class="catagory-content">
                <div class="row">
                  <div class="col-md-12">
                    <ul class="list-unstyled">
                      <?php $sql_pub = mysqli_query($conn, "SELECT title FROM publications WHERE lang='$lang' AND del=0 ORDER BY id ASC, group_id ASC"); while($row_pub = mysqli_fetch_array($sql_pub)) { ?>
                      <li><a href="#"><i class="fa fa-angle-right"></i> &nbsp;<?php echo $row_pub['title']; ?></a></li>
                      <?php } ?>
                    </ul>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="add-widget"> <img src='images/pdf.png' width="25"/><a href="registered-contractors"> &nbsp;
          <?php if($lang == 1) { ?>
          Download Registered Contractors
          <?php } if($lang == 2) { ?>
          ලියාපදිංචි කොන්ත්‍රාත්කරුවන් බාගත කරන්න
          <?php } if($lang == 3) { ?>
          பதிவூசெய்யப்பட்ட ஒப்பந்ததாரர்களைப்பற்றி பதிவிறக்கம் செய்ய
          <?php } ?>
          (PDF)</a>
          <hr>
        <?php if(!empty($banner_2)) { ?>
          <a><img src="backend/upload/side_banners/<?php echo $banner_2; ?>" alt="NWP Engineering Department" class="img-fluid"></a>
        <?php } ?>
		  </div>
        <div class="oth-news">
          <div class="login-widget">
            <h4>
              <?php if($lang == 1) { ?>
              LOG IN
              <?php } if($lang == 2) { ?>
              ලොග් වන්න
              <?php } if($lang == 3) { ?>
              உள்நுழை
              <?php } ?>
            </h4>
			  <form method="post" id="login-form">
				<div id="errorDiv"></div>	
				<div class="form-group">
				<input type="text" name="user" placeholder="<?php if($lang == 1) { ?> User Name <?php } if($lang == 2) { ?> පරිශීලක නාමය <?php } if($lang == 3) { ?> பயனப்பெயர் <?php } ?>">
				 <span class="help-block" id="error"></span></div>
			   
				<div class="form-group">
				<input type="password" name="password" placeholder="<?php if($lang == 1) { ?> Password <?php } if($lang == 2) { ?> මුරපදය <?php } if($lang == 3) { ?> கடவூச்சொல் <?php } ?>">
				 <span class="help-block" id="error"></span></div>
				<button type=""  id="btn-login"><?php if($lang == 1) { ?> LOGIN <?php } if($lang == 2) { ?> ඇතුල් වන්න <?php } if($lang == 3) { ?> உள்நுழை <?php } ?></button>
			  </form> 
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- End All News --> 

<!-- Other News -->
<section class="oth-news">
  <div class="container">
    <div class="row">
	 
     <div class="col-lg-8">
        <div class="more-top">
          <h4>
            <?php if($lang == 1) { ?>
            PRESS RELEASE
            <?php } if($lang == 2) { ?>
            මාධ්‍ය නිවේදන
            <?php } if($lang == 3) { ?>
            செய்தி வெளியீடு
            <?php } ?>
          </h4>
        </div>
        <?php $sql_rel = mysqli_query($conn, "SELECT title, description, DATE_FORMAT(date, '%M %d %Y') AS date, pdf,img, group_id FROM press_release WHERE lang='$lang' AND del=0 ORDER BY id DESC, group_id ASC LIMIT 1");
          while($row_rel = mysqli_fetch_array($sql_rel)) { ?>
        <div class="more-content">
            <?php if(!empty($row_rel['img'])) { ?>
            <div class="more-img">
                <a href="#"><img src="backend/upload/PDF/press_release/<?php echo $row_rel['img']; ?>" alt="" class="img-fluid" style="height:170px; width: 260px; overflow:hidden"></a>
            </div> 
            <?php } ?>         
          <div class="img-content">
            <h6><a href="press-release"><?php  $pr_tle = $row_rel['title'];
			if (strlen($pr_tle) > 90) $pr_tle = substr($pr_tle, 0, strrpos(substr($pr_tle, 0, 90), ' ')) . '...'; echo $pr_tle; ?></a></h6>
            <ul class="list-unstyled list-inline">
              <?php if(!empty($row_rel['pdf'])) { ?>
              <a href="backend/upload/PDF/press_release/<?php echo $row_rel['pdf']; ?>" target="new">
              <li class="list-inline-item"><i class="fa fa-search"></i> <?php if($lang == 1) { ?>
                VIEW
                <?php } if($lang == 2) { ?>
                බලන්න
                <?php } if($lang == 3) { ?>
                பார்க்க
                <?php } ?></li></a>
              <?php } ?>
              
			  <?php if(!empty($row_rel['img'])) { ?>
              <a href="press-release">
              <li class="list-inline-item"><?php if($lang == 1) { ?>
                READ MORE
                <?php } if($lang == 2) { ?>
                තවදුරටත් කියවන්න
                <?php } if($lang == 3) { ?>
                மேலும் வாசிக்க
                <?php } ?></li></a>
              <?php } ?>
              
              <li class="list-inline-item"><?php echo $row_rel['date']; ?></li>
            </ul>
            <p><?php $pr_des = $row_rel['description']; if (strlen($pr_des) > 250) $pr_des = substr($pr_des, 0, strrpos(substr($pr_des, 0, 250), ' ')) . '...'; echo $pr_des; ?></p>
            
			<?php if(!empty($row_rel['pdf'])) { ?>
            <p><small><a href="press-release"><?php if($lang == 1) { ?>
            READ MORE
            <?php } if($lang == 2) { ?>
            තවදුරටත් කියවන්න
            <?php } if($lang == 3) { ?>
            மேலும் வாசிக்க
            <?php } ?></a></small></p>
            <?php } ?>
            
          </div>
        </div>
        <?php } ?>     
      </div>
      
		<div class="col-lg-4 about">
            <div class="testimonial">
                <h4>
                <?php if($lang == 1) { ?>
                ANNOUNCEMENTS
                <?php } if($lang == 2) { ?>
                නිවේදන
                <?php } if($lang == 3) { ?>
                அறிவிப்புகள்
                <?php } ?></h4>
                <div class="owl-carousel testimonial-slider">
                    <?php $sql_ann = mysqli_query($conn, "SELECT title, description, DATE_FORMAT(date, '%M %d %Y') AS date FROM announcement WHERE lang='$lang' AND del=0 ORDER BY id DESC, group_id ASC LIMIT 5");
					while($row_ann = mysqli_fetch_array($sql_ann)) { ?>
                    <div class="testimonial-content">
                        <h6><?php $tle_ann = $row_ann['title']; if (strlen($tle_ann) > 80) $tle_ann = substr($tle_ann, 0, strrpos(substr($tle_ann, 0, 80), ' ')) . '...'; echo $tle_ann; ?></h6>
                        <p align="justify"><?php $des_ann = $row_ann['description']; if (strlen($des_ann) > 180) $des_ann = substr($des_ann, 0, strrpos(substr($des_ann, 0, 180), ' ')) . '...'; echo $des_ann; ?></p><br>
                    	<small><?php echo $row_ann['date']; ?></small>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>
      
      <div class="col-lg-12">
        <div class="more-top">
          <h4>
            <?php if($lang == 1) { ?>
            TENDER NOTICE
            <?php } if($lang == 2) { ?>
            ටෙන්ඩර් දැන්වීම්
            <?php } if($lang == 3) { ?>
            ஒப்பந்த அறிக்கை
            <?php } ?>
          </h4>
        </div>
        <?php $sql_tend = mysqli_query($conn, "SELECT title, description, DATE_FORMAT(date, '%M %d %Y') AS date, pdf FROM tender WHERE lang='$lang' AND del=0 ORDER BY id DESC, group_id ASC LIMIT 3");
		if(mysqli_num_rows($sql_tend) == 0) {
			echo '<p>';
			
			if($lang == 1) {
				echo 'Currently no tenders to display.';
			}
			if($lang == 2) {
				echo 'දැනට ප්‍රදර්ශනය කිරීමට ටෙන්ඩර් නොමැත.';
			}
			if($lang == 3) {
				echo 'தற்போது காண்பிக்க டெண்டர்கள் இல்லை.';
			}
			
			echo '</p><br><br>';
		
		} else {
          while($row_tend = mysqli_fetch_array($sql_tend)) { ?>
        <div class="more-content">
          <div class="img-content">
            <h6><a href="backend/upload/PDF/tenders/<?php echo $row_tend['pdf']; ?>" target="new"><?php echo $row_tend['title']; ?></a></h6>
            <ul class="list-unstyled list-inline">
              <a href="backend/upload/PDF/tenders/<?php echo $row_tend['pdf']; ?>" target="new">
              <li class="list-inline-item"><i class="fa fa-search"></i> <?php if($lang == 1) { ?>
                VIEW
                <?php } if($lang == 2) { ?>
                බලන්න
                <?php } if($lang == 3) { ?>
                பார்க்க
                <?php } ?></li>
              </a>
              <li class="list-inline-item"><?php echo $row_tend['date']; ?></li>
            </ul>
            <p><?php echo $row_tend['description']; ?></p>
          </div>
        </div>
        <?php }} ?>
      </div>
    </div>
  </div>
</section>
<!-- End Other News --> 

<!-- Footer -->
<?php include 'common/footer.php'; ?>
<!-- End Footer --> 

<!-- =========================================
JavaScript Files
========================================== --> 

<!-- jQuery JS --> 
<script src="js/assets/vendor/jquery-1.12.4.min.js"></script> 
<!-- Poppers Js --> 
<script src="js/assets/popper.js"></script> 
<!-- Bootstrap --> 
<script src="js/assets/bootstrap.min.js"></script> 
<!-- Sticky Js --> 
<script src="js/assets/jquery.sticky.js"></script> 
<!-- WOW JS --> 
<script src="js/assets/wow.min.js"></script> 
<!-- Smooth Scroll --> 
<script src="js/assets/smooth-scroll.js"></script> 
<!-- Mean Menu --> 
<script src="js/assets/jquery.meanmenu.min.js"></script> 
<!-- News Ticker --> 
<script src="js/assets/jquery.newsticker.min.js"></script> 
<!-- Owl Carousel --> 
<script src="js/assets/owl.carousel.min.js"></script> 
<!-- Magnific Popup --> 
<script src="js/assets/jquery.magnific-popup.min.js"></script> 
<!-- Syotimer --> 
<script src="js/assets/jquery.syotimer.min.js"></script> 
<!-- Custom JS --> 
<script src="js/plugins.js"></script> 
<script src="js/custom.js"></script> 
<!-- Vertical Nav Bar --> 
<script src="js/nav-bar/menu.min.js"></script> 

<!-- JavaScript Validation For Login Page -->
<script src="js/assets/jquery.validate.min.js"></script>
<script src="js/form_validate.js"></script>

<script>
$(function() {
  $('#auto-collapse-menu-demo').metisMenu();
});
</script>
</body>
</html>