<?php
include "backend/db/db.php";
session_start();
$file = pathinfo($_SERVER['PHP_SELF'], PATHINFO_FILENAME);
$_SESSION['file'] = $file;

if(!isset($_COOKIE['lang'])) {
   header("Location: index");

} else {
	$lang = htmlspecialchars(strip_tags(trim($_COOKIE['lang'])), ENT_QUOTES, 'UTF-8');
}
date_default_timezone_set('Asia/Colombo');
?>
<!-- Top Bar -->
<section class="top-bar">
  <div class="container">
    <div class="bar-content">
      <div class="row">
        <div class="col-md-8 col-sm-6">
          <div class="bar-left">
            <ul class="list-unstyled list-inline">
              <li class="list-inline-item"><i class="fa fa-calendar-check-o"></i><?php echo date("F j, Y"); ?></li>
              <?php if($lang == 2 || $lang == 3) { ?><li class="list-inline-item"><a href="functions/lang_eng">English </a></li><?php } ?>
              <?php if($lang == 1 || $lang == 3) { ?><li class="list-inline-item"><a href="functions/lang_sin">සිංහල </a></li><?php } ?>
              <?php if($lang == 1 || $lang == 2) { ?><li class="list-inline-item"><a href="functions/lang_tami">தமிழ் </a></li><?php } ?>
            </ul>
          </div>
        </div>
        <div class="col-md-4 col-sm-6 hidden-xs">
          <div class="bar-social text-right">
            <ul class="list-unstyled list-inline">
              <li class="list-inline-item"><a href="#" class="facebook"><i class="fa fa-facebook"></i></a></li>
              <li class="list-inline-item"><a href="#" class="twitter"><i class="fa fa-twitter"></i></a></li>
              <li class="list-inline-item"><a href="#" class="linkedin"><i class="fa fa-linkedin"></i></a></li>
              <li class="list-inline-item"><a href="#" class="google-plus"><i class="fa fa-google-plus"></i></a></li>
              <li class="list-inline-item"><a href="#" class="rss"><i class="fa fa-rss"></i></a></li>
              <li class="list-inline-item"><a href="#" class="youtube"><i class="fa fa-youtube"></i></a></li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- End Top Bar --> 

<!-- Logo Area -->
<section class="logo-area hidden-xs">
  <div class="container">
    <div class="row">
      <div class="col-md-8 col-sm-10">
        <div class="logo"> <a href="home"><img src="images/logo.png" alt="" class="img-fluid" style="width: 600px;"></a> </div>
      </div>
      <div class="col-md-4 col-sm-2">
	  <script async src="https://cse.google.com/cse.js?cx=011539734032849281846:srriiczq5jd"></script>
	  <style>

	 @media (min-width: 768px) and (max-width: 991px) {
		  .gsc-input {
			  height: 26px !important;
		  }
	  }
	 @media (min-width: 992px) and (max-width: 1199px) {
		  .gsc-input {
			  height: 26px !important;
		  }
	  }
	  @media (min-width: 1200px) {
		  .gsc-input {
			  height: 35px !important;
		  }
	  }
	  .cse .gsc-search-button-v2, .gsc-search-button-v2 {
		padding: 15px;
	  }
		.cse .gsc-control-cse, .gsc-control-cse {
			padding: 18px 0 0;
		}
	.gsc-search-box-tools .gsc-search-box .gsc-input {
		padding-right: 5px;
	}
	  </style>
	  <div class="gcse-search"></div>
        <!--<div class="searchbar text-right">
          <form action="#">
            <input placeholder="<?php //if($lang == 1) { ?> Search Here... <?php //} if($lang == 2) { ?> සොයන්න... <?php //} if($lang == 3) { ?> தேடல்... <?php //} ?>" type="text" required>
            <button type="submit"><i class="fa fa-search"></i></button>
          </form>
        </div>-->
      </div>
    </div>
  </div>
</section>
<!-- End Logo Area --> 