<?php include "common/user_log.php"; 

date_default_timezone_set('Asia/Colombo');
$date = date("Y-m-d");

if (isset($_GET['daterange'])) {
	$daterange = htmlspecialchars(trim($_GET['daterange']), ENT_QUOTES, 'UTF-8');
	$date1 = substr($daterange, 0, 10);
	$date2 = substr($daterange, 13, 23);

} else {
	date_default_timezone_set('Asia/Colombo');
	$date = date("Y-m-d");
	$date1 = $date2 = $date;	
}

?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>NWP Engineering Department</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.5 -->
    <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="dist/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="dist/css/ionicons.min.css">
    <!-- daterange picker -->
    <link rel="stylesheet" href="plugins/daterangepicker/daterangepicker-bs3.css">
    <!-- iCheck for checkboxes and radio inputs -->
    <link rel="stylesheet" href="plugins/iCheck/all.css">
    <!-- Bootstrap Color Picker -->
    <link rel="stylesheet" href="plugins/colorpicker/bootstrap-colorpicker.min.css">
    <!-- Bootstrap time Picker -->
    <link rel="stylesheet" href="plugins/timepicker/bootstrap-timepicker.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="plugins/select2/select2.min.css">
	<!-- DataTables -->
    <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
         folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <link rel="stylesheet" href="bootstrap-sweetalert/lib/sweet-alert.css" />
  </head>
  <body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">

      <header class="main-header">
        <!-- Logo -->
         <a href="home.php" class="logo">
          <!-- mini logo for sidebar mini 50x50 pixels -->
         <span class="logo-mini"><img src="img/logo.png" width="100"></span>
          <!-- logo for regular state and mobile devices -->
        <span class="logo-lg"><b><img src="img/logo.png" width="100"></b></span>
        </a>
        <!-- Header Navbar: style can be found in header.less -->
        <nav class="navbar navbar-static-top" role="navigation">
          <!-- Sidebar toggle button-->
          <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
            <span class="sr-only">Toggle navigation</span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
			 <span class="logo-lg">
             &nbsp;&nbsp;<font face="Lucida Sans Unicode, Lucida Grande, sans-serif">NWP Engineering Department</font></span>
          </a>
		
          <div class="navbar-custom-menu">
            <ul class="nav navbar-nav">

              <!-- User Account: style can be found in dropdown.less -->
              <li class="dropdown user user-menu">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                  <img src="dist/img/user2-160x160.png" class="user-image" alt="User Image">
                  <span class="hidden-xs"><?php echo $name; ?></span>
                </a>
                <ul class="dropdown-menu">
                  <!-- User image -->
                  <li class="user-header">
                    <img src="dist/img/user2-160x160.png" class="img-circle" alt="User Image">
                    <p>
             NWP Engineering Department
                    
                    </p>
                  </li>
                  <!-- Menu Body -->
                 
                  <!-- Menu Footer-->
                  <li class="user-footer">
                    <div class="pull-left">
                      
                    </div>
                    <div class="pull-right">
                      <a href="distroy.php" class="btn btn-default btn-flat">Sign out</a>
                    </div>
                  </li>
                </ul>
              </li>
              <!-- Control Sidebar Toggle Button -->
              <li>
                <a href="#" data-toggle="control-sidebar"><i class="fa fa-gears"></i></a>
              </li>
            </ul>
          </div>
        </nav>
      </header>
      <!-- Left side column. contains the logo and sidebar -->
      <aside class="main-sidebar">
        <!-- sidebar: style can be found in sidebar.less -->
        <section class="sidebar">
          <!-- Sidebar user panel -->
    <?php include "common/sidebar.php"; ?>  
     
        </section>
        <!-- /.sidebar -->
      </aside>

      <!-- Content Wrapper. Contains page content -->
      <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>
            Approved Vouchers
          </h1>
          
    <ol class="breadcrumb">
      <li><a href="home.php"><i class="fa fa-home"></i> Home</a></li>
    </ol>
        </section>

        <!-- Main content -->
        <section class="content">

<!-- ************************************************* -->
  <div class="box box-info"> 
    <div class="box-header with-border">
      <h3 class="box-title">Select Date</h3>
    </div>

    <div class="box-body"> 
      <form name="form" id="form">
<br>
              <div class="input-group"> 
                <div class="input-group-addon"> <i class="fa fa-calendar"></i> 
                </div>
                <input type="text" class="form-control pull-left" name="daterange" id="reservation" value="<?php if(empty($daterange)){ echo $date1.' '.'-'.' '.$date2;} else { echo $daterange; }?>" required onChange="formHandler($(this).val())">
              </div><br><br>

      </form>
    </div>
  </div> 

 <!-- /.table -->
        
    <div class="box box-info"> 
      <div class="box-header"> 
        <h3 class="box-title">Approved Travel Expenses</h3>
      </div>
      <!-- /.box-header -->
      <div class="box-body table-responsive"> 
        <table id="example1" class="table table-bordered table-striped">
          <thead>
            <tr>
                <th>ID</th>
                <th>Date</th>
                <th>Voucher No</th>
                <th>Cheque No</th>
                <th>Officer Name</th>
                <th>Departure</th>
                <th>Departure Time</th>
                <th>Arrival Time</th>
                <th>Paid Amount (Rs)</th>
				<th class="only_eng">Edit Voucher</th>
                <th>Voucher Print</th>
            </tr>
          </thead>
          <tbody>
            <?php 
            $sql="SELECT * FROM travel_expenses WHERE flag = '1' AND vou_no!=0 AND (date BETWEEN '$date1' AND '$date2') ORDER BY vou_no";
              $result=mysqli_query($conn, $sql);
              $x = 0;
              while ($row = mysqli_fetch_array($result)){ $x++;
            ?>

            <tr>
              <td><?php echo $x; ?>.</td>
                <td><?php echo $row['date']; ?></td>
                <td><?php echo $row['vou_no']; ?></td>
                <td><?php echo $row['chq_no']; ?></td>
                <td><?php echo $row['officer_name']; ?></td>
                <td><?php echo $row['dep_place']; ?></td>
                <td><?php echo $row['dep_time']; ?></td>
                <td><?php echo $row['arr_time']; ?></td>
                <td><?php echo $row['paid_amount']; ?></td>
				<td align="center" class="only_eng"><button  class="btn btn-info btn-sm btn_up" data-toggle="modal" data-target="#edit_lng" value="<?php echo $row['id']; ?>"><span class="glyphicon glyphicon-pencil"></span> &nbsp;EDIT </button></td>
				<td><a href="travel_exp_voucher.php?id=<?php echo $row['vou_no'] ;?>" class="btn btn-default btn-sm" target="_new"> 
                <span class="fa fa-print"></span> PRINT </a></td>
            </tr>
            <?php  } ?>
          </tbody>
        </table>
      </div>
      <!-- /.box-body -->
    </div>
    <a href="travel_exp_print.php?d1=<?php echo $date1; ?>&&d2=<?php echo $date2; ?>" target="_blank" class="btn btn-danger">PRINT PREVIEW</a>
  </section>
   
      </div>
	      <!-- /.End table -->
<!-- ************************************************* -->
      
           <!-- /.col -->
              </div><!-- /.row -->
            </div><!-- /.box-body -->
  

 <!-- Modal -->
<div class="modal fade" id="edit_lng" role="dialog">
  <div class="modal-dialog"> 
    
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title" id="test_id">Edit Voucher</h4>
      </div>
      <div class="modal-body">
        <form id="form_projects_up" action="javascript:void(0);">
            <div class="row">
              <div class="col-md-12 col-sm-12">
                <div class="form-group">
                  <label>Cheque No:<font color="#FF0000"><strong>*</strong></font></label>
                  <input type="text" class="form-control" name="chq_no_up" id="chq_no_up" autocomplete="off" required>
                </div>
                <div class="form-group">
                  <label>Expenses Details:<font color="#FF0000"><strong>*</strong></font></label>
                  <input type="text" class="form-control" name="exp_detail_up" id="exp_detail_up" autocomplete="off" required>
                </div>
                <div class="form-group">
                  <label>Name of the officer:<font color="#FF0000"><strong>*</strong></font></label>
                  <input type="text" class="form-control" name="off_name_up" id="off_name_up" autocomplete="off" required>
                </div>
                <div class="form-group">
                  <label>Position:<font color="#FF0000"><strong>*</strong></font></label>
                  <input type="text" class="form-control" name="position_up" id="position_up" autocomplete="off" required>
                </div>
                <div class="form-group">
                  <label>Department:<font color="#FF0000"><strong>*</strong></font></label>
                  <input type="text" class="form-control" name="department_up" id="department_up" autocomplete="off" required>
                </div>
                <div class="form-group">
                  <label>Consolidated Annual Salary (Rs):<font color="#FF0000"><strong>*</strong></font></label>
                  <input type="text" class="form-control" name="annual_sal_up" id="annual_sal_up" autocomplete="off" required>
                </div>
                <div class="form-group">
                  <label>Other Allowances Approved or Travel Cost (Rs):<font color="#FF0000"><strong>*</strong></font></label>
                  <input type="text" class="form-control" name="approve_all_up" id="approve_all_up" autocomplete="off" required>
                </div>
                <div class="form-group">
                  <label>Combined Allowances (Rs):<font color="#FF0000"><strong>*</strong></font></label>
                  <input type="text" class="form-control" name="combined_all_up" id="combined_all_up" autocomplete="off" required>
                </div>
                <div class="form-group">
                  <label>Departure:<font color="#FF0000"><strong>*</strong></font></label>
                  <input type="text" class="form-control" name="departure_up" id="departure_up" autocomplete="off" required>
                </div>
                <div class="form-group">
                  <label>Total Amount Requested:<font color="#FF0000"><strong>*</strong></font></label>
                  <input type="text" class="form-control" name="req_amount_up" id="req_amount_up" autocomplete="off" required>
                </div>
				<div class="form-group">
                  <label>Advance Payment:<font color="#FF0000"><strong>*</strong></font></label>
                  <input type="text" class="form-control" name="adv_pay_up" id="adv_pay_up" autocomplete="off" required>
                </div> 				
                <div class="form-group">
                  <label>Reason:<font color="#FF0000"><strong>*</strong></font></label>
                  <textarea type="text" class="form-control" name="reason_up" id="reason_up" autocomplete="off" rows=3 required></textarea>
                </div>
              </div>
            </div>
			<div class="box-footer">
				<input type="hidden" id="vou_id_up" name="vou_id_up">
				<button class="btn btn-danger" name="btn_update">UPDATE</button>
			</div>			
			
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div> 
          

          <div class="row">
            
    
    
      </div>
      <!-- /.col (right) -->
         

      </div>
<footer class="main-footer"> 
<div class="pull-right hidden-xs">
          
        </div>  <strong>Copyright &copy; NWP Engineering Department</strong> All rights reserved.
      </footer>

      <!-- Control Sidebar -->
      <aside class="control-sidebar control-sidebar-dark">
        <!-- Create the tabs -->
        <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
          <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>
          <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
        </ul>
        <!-- Tab panes -->
        <div class="tab-content">
          <!-- Home tab content -->
          <div class="tab-pane" id="control-sidebar-home-tab">
          </div><!-- /.tab-pane -->

          </div><!-- /.tab-pane -->
        </div>
      </aside><!-- /.control-sidebar -->
      <!-- Add the sidebar's background. This div must be placed
           immediately after the control sidebar -->
      <div class="control-sidebar-bg"></div>
    </div><!-- ./wrapper -->

    <!-- jQuery 2.1.4 -->
    <script src="plugins/jQuery/jQuery-2.1.4.min.js"></script>
    <!-- Bootstrap 3.3.5 -->
    <script src="bootstrap/js/bootstrap.min.js"></script>
    <!-- Select2 -->
    <script src="plugins/select2/select2.full.min.js"></script>
	<!-- DataTables -->
    <script src="plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
    <!-- InputMask -->
    <script src="plugins/input-mask/jquery.inputmask.js"></script>
    <script src="plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
    <script src="plugins/input-mask/jquery.inputmask.extensions.js"></script>
    <!-- date-range-picker -->
    <script src="plugins/daterangepicker_n/moment.min.js"></script>
    <script src="plugins/daterangepicker_n/daterangepicker.js"></script>
    <!-- bootstrap color picker -->
    <script src="plugins/colorpicker/bootstrap-colorpicker.min.js"></script>
    <!-- bootstrap time picker -->
    <script src="plugins/timepicker/bootstrap-timepicker.min.js"></script>
    <!-- SlimScroll 1.3.0 -->
    <script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
    <!-- iCheck 1.0.1 -->
    <script src="plugins/iCheck/icheck.min.js"></script>
    <!-- FastClick -->
    <script src="plugins/fastclick/fastclick.min.js"></script>
    <!-- AdminLTE App -->
    <script src="dist/js/app.min.js"></script>
    <!-- AdminLTE for demo purposes -->
    <script src="dist/js/demo.js"></script>
    <script src="bootstrap-sweetalert/lib/sweet-alert.min.js"></script>
	
    <!-- Page script -->
    <script>
      $(function () {
        //Initialize Select2 Elements
        $(".select2").select2();

        //Datemask dd/mm/yyyy
        $("#datemask").inputmask("dd/mm/yyyy", {"placeholder": "yyyy-mm-dd"});
        //Datemask2 mm/dd/yyyy
        $("#datemask2").inputmask("mm/dd/yyyy", {"placeholder": "yyyy-mm-dd"});
        //Money Euro
        $("[data-mask]").inputmask();

        //Date range picker
        $('#reservation').daterangepicker();
        //Date range picker with time picker
       $('#date_start').daterangepicker({timePicker: false, timePickerIncrement: 30, format: 'YYYY-MM-DD'});
       $('#date_comp').daterangepicker({timePicker: false, timePickerIncrement: 30, format: 'YYYY-MM-DD'});
       $('#date_award').daterangepicker({timePicker: false, timePickerIncrement: 30, format: 'YYYY-MM-DD'});


       $('#date_start_up').daterangepicker({timePicker: false, timePickerIncrement: 30, format: 'YYYY-MM-DD'});
       $('#date_comp_up').daterangepicker({timePicker: false, timePickerIncrement: 30, format: 'YYYY-MM-DD'});
		   $('#date_award_up').daterangepicker({timePicker: false, timePickerIncrement: 30, format: 'YYYY-MM-DD'});


		   $('#exp_date_up').daterangepicker({timePicker: false, timePickerIncrement: 30, format: 'YYYY-MM-DD'});
        //Date range as a button
        $('#daterange-btn').daterangepicker(
            {
              ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month')]
              },
              startDate: moment().subtract(29, 'days'),
           
            },
        function (start) {
          $('#reportrange span').html(start.format('MMMM D, YYYY'));
        }
        );

        //iCheck for checkbox and radio inputs
        $('input[type="checkbox"].minimal, input[type="radio"].minimal').iCheck({
          checkboxClass: 'icheckbox_minimal-blue',
          radioClass: 'iradio_minimal-blue'
        });
        //Red color scheme for iCheck
        $('input[type="checkbox"].minimal-red, input[type="radio"].minimal-red').iCheck({
          checkboxClass: 'icheckbox_minimal-red',
          radioClass: 'iradio_minimal-red'
        });
        //Flat red color scheme for iCheck
        $('input[type="checkbox"].flat-red, input[type="radio"].flat-red').iCheck({
          checkboxClass: 'icheckbox_flat-green',
          radioClass: 'iradio_flat-green'
        });

        
      });
	  
      $(function () {
        $("#example1").DataTable();
        $('#example2').DataTable({
          "paging": true,
          "lengthChange": false,
          "searching": false,
          "ordering": true,
          "info": true,
          "autoWidth": false
        });
      });
	  
function formHandler(date){
  window.location.href = 'approved_travel_exp?daterange='+date;
}

/******************************************* Load Form Data **************************************/

$(".btn_up").click(function(){	
	load_form_data($(this).val());
	$("#vou_id_up").val($(this).val());
});

function load_form_data(reg_id){
	$.post( "function/travel_exp_fun.php", { get_dataset: "data", reg_id : reg_id }, function( data ) {
		$.each(data, function (index, data) {

      $('#chq_no_up').val(data.chq_no);
      $('#exp_detail_up').val(data.exp_detail);
      $('#off_name_up').val(data.officer_name);
      $('#position_up').val(data.position);
      $('#department_up').val(data.department);
      $('#annual_sal_up').val(data.annual_sal);
      $('#approve_all_up').val(data.approve_all);
      $('#combined_all_up').val(data.combined_all);
      $('#departure_up').val(data.departure);
      $('#reason_up').val(data.reason); 
      $('#req_amount_up').val(data.req_amount);  
      $('#adv_pay_up').val(data.adv_pay);  
			
	});

	}, "json");
}

/****************************** update  *********************************************************/

$("#form_projects_up").on('submit',(function(e) {
	var date = $('#reservation').val();
    /*for (instance in CKEDITOR.instances) {
        CKEDITOR.instances[instance].updateElement();
    }*/

    e.preventDefault();
    $.ajax({
    url: "function/travel_exp_fun.php",
    type: "POST",
    data:  new FormData(this),
    contentType: false,
        cache: false,
    processData:false,
    beforeSend : function()
    {
      //$("#preview").fadeOut();
      //$("#err").fadeOut();
    },
    success: function(data){
      if(data.status=='ok')
      {
        swal({
          title: "Updated!",
          text: "Successfully Updated!",
          type: "success",
          confirmButtonText: "OK"
            },
            function (isConfirm) {
          if (isConfirm) {
              window.location.href = "approved_travel_exp.php?daterange="+date;
          }
        });
      }
	  else if(data.status=='ext2')
      {
        swal("", "Cheque No Already Exist!", "warning");
      }
	  else
      {
        swal("Oops...", "Something went wrong!", "warning");
      }
      
      },
      error: function(e) 
      {
        //$("#err").html(e).fadeIn();
        alert("err2");
      }
   });
  //alert("Done");
}));
  
</script>
		
</body>
</html>