<?php include "common/user_log.php"; ?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>NWP Engineering Department</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.5 -->
    <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="dist/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="dist/css/ionicons.min.css">
    <!-- daterange picker -->
    <link rel="stylesheet" href="plugins/daterangepicker/daterangepicker-bs3.css">
    <!-- iCheck for checkboxes and radio inputs -->
    <link rel="stylesheet" href="plugins/iCheck/all.css">
    <!-- Bootstrap Color Picker -->
    <link rel="stylesheet" href="plugins/colorpicker/bootstrap-colorpicker.min.css">
    <!-- Bootstrap time Picker -->
    <link rel="stylesheet" href="plugins/timepicker/bootstrap-timepicker.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="plugins/select2/select2.min.css">
	<!-- DataTables -->
    <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
         folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <link rel="stylesheet" href="bootstrap-sweetalert/lib/sweet-alert.css" />
  </head>
  <body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">

      <header class="main-header">
        <!-- Logo -->
         <a href="home.php" class="logo">
          <!-- mini logo for sidebar mini 50x50 pixels -->
         <span class="logo-mini"><img src="img/logo.png" width="100"></span>
          <!-- logo for regular state and mobile devices -->
        <span class="logo-lg"><b><img src="img/logo.png" width="100"></b></span>
        </a>
        <!-- Header Navbar: style can be found in header.less -->
        <nav class="navbar navbar-static-top" role="navigation">
          <!-- Sidebar toggle button-->
          <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
            <span class="sr-only">Toggle navigation</span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
			 <span class="logo-lg">
             &nbsp;&nbsp;<font face="Lucida Sans Unicode, Lucida Grande, sans-serif">NWP Engineering Department</font></span>
          </a>
		
          <div class="navbar-custom-menu">
            <ul class="nav navbar-nav">

              <!-- User Account: style can be found in dropdown.less -->
              <li class="dropdown user user-menu">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                  <img src="dist/img/user2-160x160.png" class="user-image" alt="User Image">
                  <span class="hidden-xs"><?php echo $name; ?></span>
                </a>
                <ul class="dropdown-menu">
                  <!-- User image -->
                  <li class="user-header">
                    <img src="dist/img/user2-160x160.png" class="img-circle" alt="User Image">
                    <p>
             NWP Engineering Department
                    
                    </p>
                  </li>
                  <!-- Menu Body -->
                 
                  <!-- Menu Footer-->
                  <li class="user-footer">
                    <div class="pull-left">
                      
                    </div>
                    <div class="pull-right">
                      <a href="distroy.php" class="btn btn-default btn-flat">Sign out</a>
                    </div>
                  </li>
                </ul>
              </li>
              <!-- Control Sidebar Toggle Button -->
              <li>
                <a href="#" data-toggle="control-sidebar"><i class="fa fa-gears"></i></a>
              </li>
            </ul>
          </div>
        </nav>
      </header>
      <!-- Left side column. contains the logo and sidebar -->
      <aside class="main-sidebar">
        <!-- sidebar: style can be found in sidebar.less -->
        <section class="sidebar">
          <!-- Sidebar user panel -->
    <?php include "common/sidebar.php"; ?>  
     
        </section>
        <!-- /.sidebar -->
      </aside>

      <!-- Content Wrapper. Contains page content -->
      <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>
            Contractor Registry
          </h1>
          
    <ol class="breadcrumb">
      <li><a href="home.php"><i class="fa fa-home"></i> Home</a></li>
    </ol>
        </section>

        <!-- Main content -->
        <section class="content">

<!-- ************************************************* -->
  <div class="box box-info only_eng"> 
    <div class="box-header with-border"> 
      <h3 class="box-title">Contractor Registration</h3>
    </div>

    <div class="box-body"> 
      <!-- text input -->
      <div class="form-group"> 
        <label>Registered Year:<font color="#FF0000"><strong>*</strong></font></label>
        <input type="text" class="form-control error" id="reg_year" autocomplete="off">
      </div>
	  
	  <div class="form-group"> 
        <label>Name:<font color="#FF0000"><strong>*</strong></font></label>
        <input type="text" class="form-control error" id="name" autocomplete="off">
      </div>
	  
	  <div class="form-group"> 
        <label>Address:<font color="#FF0000"><strong>*</strong></font></label>
        <input type="text" class="form-control error" id="address" autocomplete="off">
      </div>
	  
	  <div class="form-group"> 
        <label>Business Reg. No:<font color="#FF0000"><strong>*</strong></font></label>
        <input type="text" class="form-control error" id="business_reg" autocomplete="off">
      </div>
	  
	  <div class="form-group"> 
        <label>Telephone (Home):</label>
        <input type="text" class="form-control" id="tel_home" autocomplete="off">
		<span id="valid_tel_home" style="display:none" class="formError"><font color="#F44336">Please Enter Valid Contact Number</font></span>		
      </div>
	  
	  <div class="form-group"> 
        <label>Telephone (Office):</label>
        <input type="text" class="form-control" id="tel_office" autocomplete="off">
		<span id="valid_tel_office" style="display:none" class="formError"><font color="#F44336">Please Enter Valid Contact Number</font></span>
      </div>
	  
	  <div class="form-group"> 
        <label>Telephone (Mobile):<font color="#FF0000"><strong>*</strong></font></label>
        <input type="text" class="form-control error" id="tel_mobile" autocomplete="off">
		<span id="valid_tel_mobile" style="display:none" class="formError"><font color="#F44336">Please Enter Valid Mobile Number</font></span>
      </div>
	  
	  <div class="form-group"> 
        <label>Fax No:</label>
        <input type="text" class="form-control" id="fax" autocomplete="off">
		<span id="valid_tel_fax" style="display:none" class="formError"><font color="#F44336">Please Enter Valid Fax Number</font></span>
      </div>
	  
	  <div class="form-group"> 
        <label>Email Address:</label>
        <input type="text" class="form-control" id="email" autocomplete="off">
		<span id="val_valid_mail" style="display:none" class="formError"><font color="#F44336">Please Enter Valid Email Address</font></span>
      </div>
	  
	  <div class="form-group"> 
        <label>SIDA Reg. No:<font color="#FF0000"><strong>*</strong></font></label>
        <input type="text" class="form-control error" id="SIDA_no" autocomplete="off">
      </div>
	  
	  	<div class="form-group">
              <label>Expiry Date:<font color="#FF0000"><strong>*</strong></font></label>            
            <div class="input-group"> 
              <div class="input-group-addon"> <i class="fa fa-calendar"></i> </div>
              <input type="text" class="form-control pull-right error" id="exp_date"  value="<?php echo date('Y-m-d'); ?>" autocomplete="off">
            </div>
        </div>
		
		<div class="form-group"> 
		  <label>Select Building Grade:<font color="#FF0000"><strong>*</strong></font></label>
		  <select class="form-control select2 error" id="bldg_grade" style="width: 100%;">
			<option value=""></option>
			<option value="C1">C1</option>
			<option value="C2">C2</option>
			<option value="C3">C3</option>
			<option value="C4">C4</option>
			<option value="C5">C5</option>
			<option value="C6">C6</option>
			<option value="C7">C7</option>
			<option value="C8">C8</option>
			<option value="C9">C9</option>
		  </select>
		</div>	
		
		<div class="form-group"> 
		  <label> 
		  <input type="checkbox" id="vat_reg" class="minimal"> &nbsp; &nbsp; VAT Registered Contractor</label>
		</div>

	  <div class="form-group"> 
        <label>VAT Reg. No:</label>
        <input type="text" class="form-control error" id="VAT_no" autocomplete="off">
      </div>		
		
            <span style="color: red;" class="pull-right">* Required Fields</span>
      <!-- /.box-body -->
      <div class="box-footer"> 
        <button  id="btn_submit" class="btn btn-primary">SUBMIT</button>
      </div>

    </div>	
  </div>
  
  

 <!-- /.table -->
        
    <div class="box box-info"> 
      <div class="box-header"> 
        <h3 class="box-title">Registered Contractors</h3>
      </div>
      <!-- /.box-header -->
      <div class="box-body table-responsive"> 
        <table id="example1" class="table table-bordered table-striped">
          <thead>
            <tr> 
              <th>ID</th>
              <th>Reg Year</th>
              <th>Reg Date</th>
              <th>Name</th>
              <th>Address</th>
              <th>Reg. No</th>
              <th>Mobile No</th>
              <th>SIDA No</th>
              <th>Grade</th>
              <th class="only_eng">Edit</th>
              <th class="only_eng">Remove</th>
            </tr>
          </thead>
          <tbody>
            <?php 
              $sql="SELECT * FROM contractor_reg WHERE del=0 and id>0 ORDER BY id ASC";
              $result=mysqli_query($conn, $sql);

              $x = 0;
              while ($row = mysqli_fetch_array($result)){ $x++;
            ?>
            <tr> 
              <td><?php echo $x; ?>.</td>
              <td><?php echo $row['reg_year']; ?></td>
              <td><?php echo $row['reg_date']; ?></td>
              <td><?php echo $row['name']; ?></td>
              <td><?php echo $row['address']; ?></td>
              <td><?php echo $row['business_reg']; ?></td>
              <td><?php echo $row['tel_mobile']; ?></td>
              <td><?php echo $row['SIDA_no']; ?></td>
              <td><?php echo $row['bldg_grade']; ?></td>
              <td align="center" class="only_eng">
			  <button  class="btn btn-info btn-sm btn_up" data-toggle="modal" data-target="#edit_lng" value="<?php echo $row['id']; ?>"><span class="glyphicon glyphicon-pencil"></span> &nbsp;EDIT </button>
			  </td>
              <td align="center" class="only_eng"><button value="<?php echo $row['id']; ?>" class="btn btn-danger btn-sm btn_dell">
                <span class="glyphicon glyphicon-trash"></span> &nbsp;DELETE </button></td>
            </tr>
            <?php  } ?>
          </tbody>
        </table>
      </div>
      <!-- /.box-body -->
    </div>
    
  </section>
   
      </div>
	      <!-- /.End table -->
<!-- ************************************************* -->
      
           <!-- /.col -->
              </div><!-- /.row -->
            </div><!-- /.box-body -->
            
          

          <div class="row">
            
    
    
      </div>
      <!-- /.col (right) -->
         

      </div>
<footer class="main-footer"> 
<div class="pull-right hidden-xs">
          
        </div>  <strong>Copyright &copy; NWP Engineering Department</strong> All rights reserved.
      </footer>

      <!-- Control Sidebar -->
      <aside class="control-sidebar control-sidebar-dark">
        <!-- Create the tabs -->
        <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
          <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>
          <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
        </ul>
        <!-- Tab panes -->
        <div class="tab-content">
          <!-- Home tab content -->
          <div class="tab-pane" id="control-sidebar-home-tab">
          </div><!-- /.tab-pane -->

          </div><!-- /.tab-pane -->
        </div>
      </aside><!-- /.control-sidebar -->
      <!-- Add the sidebar's background. This div must be placed
           immediately after the control sidebar -->
      <div class="control-sidebar-bg"></div>
    </div><!-- ./wrapper -->

<!-- Modal -->
  <div class="modal fade" id="edit_lng" role="dialog">
    <div class="modal-dialog">
    
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title" id="test_id">Edit Contractors</h4>
        </div>
        <div class="modal-body">

      <div class="form-group"> 
        <label>Registered Year:<font color="#FF0000"><strong>*</strong></font></label>
        <input type="text" class="form-control error" id="regyear_up" autocomplete="off">
      </div>
      
	  <div class="form-group"> 
        <label>Name:<font color="#FF0000"><strong>*</strong></font></label>
        <input type="text" class="form-control error" id="name_up" autocomplete="off">
      </div>
	  
	  <div class="form-group"> 
        <label>Address:<font color="#FF0000"><strong>*</strong></font></label>
        <input type="text" class="form-control error" id="address_up" autocomplete="off">
      </div>
	  
	  <div class="form-group"> 
        <label>Business Reg. No:<font color="#FF0000"><strong>*</strong></font></label>
        <input type="text" class="form-control error" id="business_reg_up" autocomplete="off">
      </div>
	  
	  <div class="form-group"> 
        <label>Telephone (Home):</label>
        <input type="text" class="form-control" id="tel_home_up" autocomplete="off">
		<span id="valid_tel_home_up" style="display:none" class="formError"><font color="#F44336">Please Enter Valid Contact Number</font></span>		
      </div>
	  
	  <div class="form-group"> 
        <label>Telephone (Office):</label>
        <input type="text" class="form-control" id="tel_office_up" autocomplete="off">
		<span id="valid_tel_office_up" style="display:none" class="formError"><font color="#F44336">Please Enter Valid Contact Number</font></span>
      </div>
	  
	  <div class="form-group"> 
        <label>Telephone (Mobile):<font color="#FF0000"><strong>*</strong></font></label>
        <input type="text" class="form-control error" id="tel_mobile_up" autocomplete="off">
		<span id="valid_tel_mobile_up" style="display:none" class="formError"><font color="#F44336">Please Enter Valid Mobile Number</font></span>
      </div>
	  
	  <div class="form-group"> 
        <label>Fax No:</label>
        <input type="text" class="form-control" id="fax_up" autocomplete="off">
		<span id="valid_tel_fax_up" style="display:none" class="formError"><font color="#F44336">Please Enter Valid Fax Number</font></span>
      </div>
	  
	  <div class="form-group"> 
        <label>Email Address:</label>
        <input type="text" class="form-control" id="email_up" autocomplete="off">
		<span id="val_valid_mail_up" style="display:none" class="formError"><font color="#F44336">Please Enter Valid Email Address</font></span>
      </div>
	  
	  <div class="form-group"> 
        <label>SIDA Reg. No:<font color="#FF0000"><strong>*</strong></font></label>
        <input type="text" class="form-control error" id="SIDA_no_up" autocomplete="off">
      </div>
	  
	  	<div class="form-group">
              <label>Expiry Date:<font color="#FF0000"><strong>*</strong></font></label>            
            <div class="input-group"> 
              <div class="input-group-addon"> <i class="fa fa-calendar"></i> </div>
              <input type="text" class="form-control pull-right error" id="exp_date_up" autocomplete="off">
            </div>
        </div>
		
		<div class="form-group"> 
		  <label>Select Building Grade:<font color="#FF0000"><strong>*</strong></font></label>
		  <select class="form-control error" id="bldg_grade_up" style="width: 100%;">
			<option value=""></option>
			<option value="C1">C1</option>
			<option value="C2">C2</option>
			<option value="C3">C3</option>
			<option value="C4">C4</option>
			<option value="C5">C5</option>
			<option value="C6">C6</option>
			<option value="C7">C7</option>
			<option value="C8">C8</option>
			<option value="C9">C9</option>
		  </select>
		</div>
		
		<div class="form-group"> 
		  <label> 
		  <input type="checkbox" id="vat_reg_up" class=""> &nbsp; &nbsp; VAT Registered Contractor</label>
		</div>	

	  <div class="form-group"> 
        <label>VAT Reg. No:</label>
        <input type="text" class="form-control error" id="VAT_no_up" autocomplete="off">
      </div>		

			<input type="hidden" id="con_reg_id" readonly>

			<span style="color: red;" class="pull-right">* Required Fields</span>
			<div class="form-group">
			  <button class="btn btn-danger" id="update_btn">UPDATE</button>
			</div>

        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
      </div>
      
    </div>
  </div>


    <!-- jQuery 2.1.4 -->
    <script src="plugins/jQuery/jQuery-2.1.4.min.js"></script>
    <!-- Bootstrap 3.3.5 -->
    <script src="bootstrap/js/bootstrap.min.js"></script>
    <!-- Select2 -->
    <script src="plugins/select2/select2.full.min.js"></script>
	<!-- DataTables -->
    <script src="plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
    <!-- InputMask -->
    <script src="plugins/input-mask/jquery.inputmask.js"></script>
    <script src="plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
    <script src="plugins/input-mask/jquery.inputmask.extensions.js"></script>
    <!-- date-range-picker -->
    <script src="plugins/daterangepicker/moment.min.js"></script>
    <script src="plugins/daterangepicker/daterangepicker.js"></script>
    <!-- bootstrap color picker -->
    <script src="plugins/colorpicker/bootstrap-colorpicker.min.js"></script>
    <!-- bootstrap time picker -->
    <script src="plugins/timepicker/bootstrap-timepicker.min.js"></script>
    <!-- SlimScroll 1.3.0 -->
    <script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
    <!-- iCheck 1.0.1 -->
    <script src="plugins/iCheck/icheck.min.js"></script>
    <!-- FastClick -->
    <script src="plugins/fastclick/fastclick.min.js"></script>
    <!-- AdminLTE App -->
    <script src="dist/js/app.min.js"></script>
    <!-- AdminLTE for demo purposes -->
    <script src="dist/js/demo.js"></script>
    <script src="bootstrap-sweetalert/lib/sweet-alert.min.js"></script>
	
    <!-- Page script -->
    <script>
      $(function () {
        //Initialize Select2 Elements
        $(".select2").select2();

        //Datemask dd/mm/yyyy
        $("#datemask").inputmask("dd/mm/yyyy", {"placeholder": "yyyy-mm-dd"});
        //Datemask2 mm/dd/yyyy
        $("#datemask2").inputmask("mm/dd/yyyy", {"placeholder": "yyyy-mm-dd"});
        //Money Euro
        $("[data-mask]").inputmask();

        //Date range picker
        $('#reservation').daterangepicker();
        //Date range picker with time picker
		   $('#exp_date').daterangepicker({timePicker: false, timePickerIncrement: 30, format: 'YYYY-MM-DD'});
		   $('#exp_date_up').daterangepicker({timePicker: false, timePickerIncrement: 30, format: 'YYYY-MM-DD'});
        //Date range as a button
        $('#daterange-btn').daterangepicker(
            {
              ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month')]
              },
              startDate: moment().subtract(29, 'days'),
           
            },
        function (start) {
          $('#reportrange span').html(start.format('MMMM D, YYYY'));
        }
        );

        //iCheck for checkbox and radio inputs
        $('input[type="checkbox"].minimal, input[type="radio"].minimal').iCheck({
          checkboxClass: 'icheckbox_minimal-blue',
          radioClass: 'iradio_minimal-blue'
        });
        //Red color scheme for iCheck
        $('input[type="checkbox"].minimal-red, input[type="radio"].minimal-red').iCheck({
          checkboxClass: 'icheckbox_minimal-red',
          radioClass: 'iradio_minimal-red'
        });
        //Flat red color scheme for iCheck
        $('input[type="checkbox"].flat-red, input[type="radio"].flat-red').iCheck({
          checkboxClass: 'icheckbox_flat-green',
          radioClass: 'iradio_flat-green'
        });

        
      });
	  
      $(function () {
        $("#example1").DataTable();
        $('#example2').DataTable({
          "paging": true,
          "lengthChange": false,
          "searching": false,
          "ordering": true,
          "info": true,
          "autoWidth": false
        });
      });
	</script>

<script>
/****************************** Insert  *********************************************************/

function isValidEmailAddress(emailAddress) {
    var pattern = /^([a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+(\.[a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+)*|"((([ \t]*\r\n)?[ \t]+)?([\x01-\x08\x0b\x0c\x0e-\x1f\x7f\x21\x23-\x5b\x5d-\x7e\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\\[\x01-\x09\x0b\x0c\x0d-\x7f\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))*(([ \t]*\r\n)?[ \t]+)?")@(([a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.)+([a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.?$/i;
    return pattern.test(emailAddress);
}

function isValidTel(tel) {
    var pattern = /^\d{10}$/;
    return pattern.test(tel);
}

$("#email").keyup(function () {
	email_validation();
});

$("#tel_home").keyup(function () {
	tel_home_validation();
});

$("#tel_office").keyup(function () {
	tel_office_validation();
});

$("#tel_mobile").keyup(function () {
	tel_mobile_validation();
});

$("#fax").keyup(function () {
	tel_fax_validation();
});

var email_val = true;
function email_validation() {
	var len = $("#email").val().length;

	if (len !== 0) {
		if (!isValidEmailAddress($("#email").val())) {
			$("#val_valid_mail").fadeIn();
			email_val = false;
		}
		else {
			$("#val_valid_mail").fadeOut();
			email_val = true;
		}
	}
}

var tel_home_val = true;
function tel_home_validation() {
	var len = $("#tel_home").val().length;

	if (len !== 0) {
		if (!isValidTel($("#tel_home").val())) {
			$("#valid_tel_home").fadeIn();
			tel_home_val = false;
		}
		else {
			$("#valid_tel_home").fadeOut();
			tel_home_val = true;
		}
	}
}

var tel_office_val = true;
function tel_office_validation() {
	var len = $("#tel_office").val().length;

	if (len !== 0) {
		if (!isValidTel($("#tel_office").val())) {
			$("#valid_tel_office").fadeIn();
			tel_office_val = false;
		}
		else {
			$("#valid_tel_office").fadeOut();
			tel_office_val = true;
		}
	}
}

var tel_mobile_val = true;
function tel_mobile_validation() {
	var len = $("#tel_mobile").val().length;

	if (len !== 0) {
		if (!isValidTel($("#tel_mobile").val())) {
			$("#valid_tel_mobile").fadeIn();
			tel_mobile_val = false;
		}
		else {
			$("#valid_tel_mobile").fadeOut();
			tel_mobile_val = true;
		}
	} else {
		$("#valid_tel_mobile").fadeOut();
		tel_mobile_val = false;
	}
}

var tel_fax_val = true;
function tel_fax_validation() {
	var len = $("#fax").val().length;

	if (len !== 0) {
		if (!isValidTel($("#fax").val())) {
			$("#valid_tel_fax").fadeIn();
			tel_fax_val = false;
		}
		else {
			$("#valid_tel_fax").fadeOut();
			tel_fax_val = true;
		}
	}
}

$("#btn_submit").click(function () {
	email_validation();
	tel_home_validation();
	tel_office_validation();
	tel_mobile_validation();
	tel_fax_validation();
	
	var reg_year = $('#reg_year').val();
	var name = $('#name').val();
	var address = $('#address').val();
	var business_reg = $('#business_reg').val();
	var tel_home = $('#tel_home').val();
	var tel_office = $('#tel_office').val();
	var tel_mobile = $('#tel_mobile').val();
	var fax = $('#fax').val();
	var email = $('#email').val();
	var SIDA_no = $('#SIDA_no').val();
	var exp_date = $('#exp_date').val();
	var bldg_grade = $('#bldg_grade').val();
	var VAT_no = $('#VAT_no').val();
	
	if($('#vat_reg').is(':checked')) {
		var vat_reg = 1;
	} else {
		var vat_reg = 0;
	}
	
	if (reg_year === '' || name === '' || address === '' || business_reg === '' || tel_mobile === '' || SIDA_no === '' || exp_date === '' || bldg_grade === '') {
		//$(".error").css("border-color", "#8b3939");
		swal("Warning!", "Please Enter Required Fields!", "warning");
	
	} else if(email_val && tel_home_val && tel_office_val && tel_mobile_val && tel_fax_val) {
		$.post('function/contractors_conn.php', {add_contractors: 'data', reg_year: reg_year, name: name, address: address, business_reg: business_reg, tel_home: tel_home, tel_office: tel_office, tel_mobile: tel_mobile, fax: fax, email: email, SIDA_no: SIDA_no, exp_date: exp_date, bldg_grade: bldg_grade, vat_reg: vat_reg , VAT_no: VAT_no },
		function (data) {
		if (data.msgType === 1) {
			setTimeout(function () {
				swal({
				title: "",
				text: "Successfully Registered!",
				type: "success",
				confirmButtonText: "OK"
				},
				function (isConfirm) {
					if (isConfirm) {
						window.location.href = "add_contractors.php";
					}
				});
			}, 100);
		
		} else if (data.msgType === 2){
			swal("MYSQL Error!", "Please Try Again!", "warning");
		
		} else if (data.msgType === 3){
			swal("", "SIDA Reg. No Already Exist!", "error");

		}		

		}, "json");	
	}
});

/******************************************* Remove Contractor **************************************/

$(".btn_dell").click(function(){
  var x = $(this).val();
  swal({
	title: "Are you sure?",
	text: "Your may not be able to recover!",
	type: "warning",
	showCancelButton: true,
	confirmButtonClass: "btn-danger",
	confirmButtonText: "Yes, delete it!",
	closeOnConfirm: false
  },
	function () {
	  del_func(x);
	}
  );
});

function del_func(reg_id){
	if(reg_id === '') {
		swal("Warning!", "Please Select Valid Contractor!", "warning");
	
	} else {	
		
		$.post( "function/contractors_conn.php", {remove_reg: "data", reg_id : reg_id}, function( data ) {	  
		    if (data.msgType === 1) {
			  swal({
				title: "Deleted!",
				text: "Successfully Deleted!",
				type: "success",
				confirmButtonText: "OK"
			  },
				  function (isConfirm) {
				if (isConfirm) {
					window.location.href = "add_contractors.php";
				}
			  });
			
			} else if(data.msgType === 3) {
				swal("", "Data Already Exist!", "error");
			
			} else{
			  swal("Oops...", "Something went wrong!", "warning");
			}
		}, "json");
	}
}

/******************************************* Load Form Data **************************************/

$(".btn_up").click(function(){	
	load_form_data($(this).val());
	$("#con_reg_id").val($(this).val());
});

function load_form_data(reg_id){
	$.post( "function/contractors_conn.php", { get_dataset: "data", reg_id : reg_id }, function( data ) {
		$.each(data, function (index, data) {
			$('#name_up').val(data.name);
			$('#regyear_up').val(data.reg_year);
			$('#address_up').val(data.address);
			$('#business_reg_up').val(data.business_reg);
			$('#tel_home_up').val(data.tel_home);
			$('#tel_office_up').val(data.tel_office);
			$('#tel_mobile_up').val(data.tel_mobile);
			$('#fax_up').val(data.fax);
			$('#email_up').val(data.email);
			$('#SIDA_no_up').val(data.SIDA_no);
			$('#exp_date_up').val(data.exp_date);
			$('#VAT_no_up').val(data.VAT_no);

			if(data.vat_reg === '1') {
				$('#vat_reg_up').prop('checked', true);
			} else {
				$('#vat_reg_up').prop('checked', false);
			}

			$('<option>').val(data.bldg_grade).html(data.bldg_grade).appendTo("#bldg_grade_up").prop("selected", true);			
		});

	}, "json");
}

/******************************************* Edit **************************************/

$("#email_up").keyup(function () {
	email_validation_up();
});

$("#tel_home_up").keyup(function () {
	tel_home_validation_up();
});

$("#tel_office_up").keyup(function () {
	tel_office_validation_up();
});

$("#tel_mobile_up").keyup(function () {
	tel_mobile_validation_up();
});

$("#fax_up").keyup(function () {
	tel_fax_validation_up();
});

var email_val_up = true;
function email_validation_up() {
	var len = $("#email_up").val().length;

	if (len !== 0) {
		if (!isValidEmailAddress($("#email_up").val())) {
			$("#val_valid_mail_up").fadeIn();
			email_val_up = false;
		}
		else {
			$("#val_valid_mail_up").fadeOut();
			email_val_up = true;
		}
	}
}

var tel_home_val_up = true;
function tel_home_validation_up() {
	var len = $("#tel_home_up").val().length;

	if (len !== 0) {
		if (!isValidTel($("#tel_home_up").val())) {
			$("#valid_tel_home_up").fadeIn();
			tel_home_val_up = false;
		}
		else {
			$("#valid_tel_home_up").fadeOut();
			tel_home_val_up = true;
		}
	}
}

var tel_office_val_up = true;
function tel_office_validation_up() {
	var len = $("#tel_office_up").val().length;

	if (len !== 0) {
		if (!isValidTel($("#tel_office_up").val())) {
			$("#valid_tel_office_up").fadeIn();
			tel_office_val_up = false;
		}
		else {
			$("#valid_tel_office_up").fadeOut();
			tel_office_val_up = true;
		}
	}
}

var tel_mobile_val_up = true;
function tel_mobile_validation_up() {
	var len = $("#tel_mobile_up").val().length;

	if (len !== 0) {
		if (!isValidTel($("#tel_mobile_up").val())) {
			$("#valid_tel_mobile_up").fadeIn();
			tel_mobile_val_up = false;
		}
		else {
			$("#valid_tel_mobile_up").fadeOut();
			tel_mobile_val_up = true;
		}
	} else {
		$("#valid_tel_mobile_up").fadeOut();
		tel_mobile_val_up = false;
	}
}

var tel_fax_val_up = true;
function tel_fax_validation_up() {
	var len = $("#fax_up").val().length;

	if (len !== 0) {
		if (!isValidTel($("#fax_up").val())) {
			$("#valid_tel_fax_up").fadeIn();
			tel_fax_val_up = false;
		}
		else {
			$("#valid_tel_fax_up").fadeOut();
			tel_fax_val_up = true;
		}
	}
}

$("#update_btn").click(function () {
	email_validation_up();
	tel_home_validation_up();
	tel_office_validation_up();
	tel_mobile_validation_up();
	tel_fax_validation_up();
	
	var reg_year = $('#regyear_up').val();
	var name = $('#name_up').val();
	var address = $('#address_up').val();
	var business_reg = $('#business_reg_up').val();
	var tel_home = $('#tel_home_up').val();
	var tel_office = $('#tel_office_up').val();
	var tel_mobile = $('#tel_mobile_up').val();
	var fax = $('#fax_up').val();
	var email = $('#email_up').val();
	var SIDA_no = $('#SIDA_no_up').val();
	var exp_date = $('#exp_date_up').val();
	var bldg_grade = $('#bldg_grade_up').val();	
	var VAT_no = $('#VAT_no_up').val();	
	
	var reg_id = $('#con_reg_id').val();
	
	if($('#vat_reg_up').is(':checked')) {
		var vat_reg = 1;
	} else {
		var vat_reg = 0;
	}
	
	if (reg_year === '' || name === '' || address === '' || business_reg === '' || tel_mobile === '' || SIDA_no === '' || exp_date === '' || bldg_grade === '') {
		swal("Warning!", "Please Enter Required Fields!", "warning");
	
	} else if(reg_id === '') {
		swal("Warning!", "Please Select Contractor!", "warning");
	
	} else if(email_val_up && tel_home_val_up && tel_office_val_up && tel_mobile_val_up && tel_fax_val_up) {

		$.post('function/contractors_conn.php', {update_reg:'data', reg_id: reg_id, reg_year: reg_year, name: name, address: address, business_reg: business_reg, tel_home: tel_home, tel_office: tel_office, tel_mobile: tel_mobile, fax: fax, email: email, SIDA_no: SIDA_no, exp_date: exp_date, bldg_grade: bldg_grade, vat_reg: vat_reg, VAT_no: VAT_no},
		
		function (data) {
			if (data.msgType === 1) {
				setTimeout(function () {
					swal({
					title: "",
					text: "Successfully Updated!",
					type: "success",
					confirmButtonText: "OK"
					},
					function (isConfirm) {
						if (isConfirm) {
							window.location.href = "add_contractors.php";
						}
					});
				}, 100);
			
			} else if (data.msgType === 2){
				swal("MYSQL Error!", "Please Try Again!", "warning");
			
			} else if (data.msgType === 3){
				swal("", "SIDA Reg. No Already Exist!", "error");
			}		

		}, "json");	
		
	}
});

</script>	
		
</body>
</html>
