<!doctype html>
<html class="no-js" lang="zxx">
<head>
<meta charset="utf-8">
<meta http-equiv="x-ua-compatible" content="ie=edge">
<title>NWP ENGINEERING DEPARTMENT - SRI LANKA</title>
<meta name="description" content="">
<meta name="viewport" content="width=device-width, initial-scale=1">
<!-- Favicon -->
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="icon" href="images/favicon.ico" type="image/x-icon">
<!-- Google Fonts -->
<link href="css/fonts.css" rel="stylesheet">
<!-- Bootstrap
<link rel="stylesheet" href="css/assets/bootstrap.min.css">
<!-- Fontawesome Icon -->
<link rel="stylesheet" href="css/assets/font-awesome.min.css">
<!-- Animate CSS -->
<link rel="stylesheet" href="css/assets/animate.css">
<!-- Mean Menu -->
<link rel="stylesheet" href="css/assets/meanmenu.min.css">
<!-- Owl Carousel -->
<link rel="stylesheet" href="css/assets/owl.carousel.min.css">
<!-- Magnific Popup -->
<link rel="stylesheet" href="css/assets/magnific-popup.css">
<!-- Custom Style -->
<link rel="stylesheet" href="css/assets/normalize.css">
<link rel="stylesheet" href="css/style.css">
<link rel="stylesheet" href="css/assets/responsive.css">
<link rel="stylesheet" href="backend/bootstrap/css/bootstrap.min.css">
<!-- DataTables -->
<link rel="stylesheet" href="backend/plugins/datatables/dataTables.bootstrap.css">
<!-- Theme style -->
<link rel="stylesheet" href="backend/dist/css/AdminLTE.min.css">
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-69018766-3"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-69018766-3');
</script>
<style>
@media screen and (max-width: 767px) {
.table-responsive {
	margin-bottom: 0;
	border: none;
}
.tbl {
	padding: 12px !important;
}
}
.tbl {
	padding: 25px;
	border: 1px solid #d9d9d9;
}
.reg_list {
	padding: 0px 0 20px;
}
</style>
</head>
<body>
<!-- Pre-Loader -->
<div id="page-preloader"><span class="spinner"></span></div>
<!-- End Pre-Loader --> 

<!-- Top Bar -->
<?php 
include 'common/top-bar.php';
include 'common/mobile-menu.php';
?>
<!-- End Top Bar --> 

<!-- Page Heading -->
<section class="p-heading text-center">
  <div class="container">
    <div class="page-bg">
      <div class="row">
        <div class="col-md-12">
          <div class="p-content">
            <h4>
              <?php if($lang == 1) { ?>
                PROJECTS
              <?php } if($lang == 2) { ?>
                ව්‍යාපෘති 
              <?php } if($lang == 3) { ?>
               திட்டம்
              <?php } ?>
            </h4>
            <ul class="list-unstyled list-inline">
              <li class="list-inline-item"><a href="home">
                <?php if($lang == 1) { ?>
                Home
                <?php } if($lang == 2) { ?>
                මුල් පිටුව
                <?php } if($lang == 3) { ?>
                முகப்பு
                <?php } ?>
                </a>
              </li>
              <li class="list-inline-item"><i class="fa fa-long-arrow-right" aria-hidden="true"></i>
                <?php if($lang == 1) { ?>
                Projects
                <?php } if($lang == 2) { ?>
                ව්‍යාපෘති
                <?php } if($lang == 3) { ?>
                திட்டம்
                <?php } ?>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- End Page Heading -->

<section class="reg_list">
  <div class="container">
    <div class="row">
      <div class="col-lg-12 col-md-12">
        <div class="tbl">
          <div class="row">
            <div class="col-lg-8 col-md-5">
              <h4>REGISTERED PROJECTS <?php 
			  if(isset($_GET['type'])) {
				$dt = htmlspecialchars(strip_tags(trim($_GET['type'])), ENT_QUOTES, 'UTF-8');
				$sql_ty = mysqli_fetch_assoc(mysqli_query($conn, "SELECT type FROM project_type WHERE id='$dt'"));
				echo ' - '.$sql_ty['type'];
			  } else { } ?></h4>
            </div>
            <div class="col-lg-4 col-md-7">
              <form class="form-horizontal" name="form" id="form">
                <div class="form-group">
                  <label for="inputEmail3" class="col-sm-4 control-label">Project Type:</label>
                  <div class="col-sm-8">
                    <select class="form-control" name="type" id="type" onChange="formHandler($(this).val())">
                      <option value="">Select Project Type...</option>
                      <?php 
                        $sql="SELECT * FROM project_type ORDER BY id DESC";
                        $result=mysqli_query($conn, $sql);
                        while ($row = mysqli_fetch_array($result)){
                      ?>
                        <option value="<?php echo $row['id']; ?>"><?php echo $row['type']; ?></option>
                      <?php } ?>
                    </select>
                  </div>
                </div>
              </form>
            </div>
          </div>
          <hr>
          <div class="table-responsive">
            <table id="tabl_reg" class="table table-bordered table-striped">
              <thead>
                <tr>
				  <th>#</th>
				  <th>Year</th>
				  <th>Project Type</th>
				  <th>Division</th>
				  <th>Project Code</th>
				  <th>Project Name</th>
				  <th>Estimate Amount (Rs)</th>
				  <th>Allocation Total (Rs)</th>
				  <th>Start Date</th>
				  <th>Current Status</th>			  
                </tr>
              </thead>
              <tbody>
                <?php 
                $text = '';
                if (!empty($_GET['type'])) {
                  $type=htmlspecialchars(trim($_GET['type']), ENT_QUOTES, 'UTF-8');
                  $text = "WHERE projects_reg.type =  '".$type."'";
                } else {
					$text = '';
				}

				$sql="SELECT
project_type.`type` AS typename,
projects_reg.id,
projects_reg.`year`,
projects_reg.`type` ,
projects_reg.pro_code,
projects_reg.pro_name,
projects_reg.state,
projects_reg.esti_amount,
projects_reg.total_cost_esti,
projects_reg.start_date,
projects_reg.copm_date,
division.division
FROM
projects_reg
Inner Join project_type ON projects_reg.`type` = project_type.id
Inner Join division ON division.id = projects_reg.division ".$text."
ORDER BY typename ASC,
division.division ASC";
              $result=mysqli_query($conn, $sql);
              $x = 0;
              while ($row = mysqli_fetch_array($result)){ $x++;
            ?>
				<tr>
				  <td><?php echo $x; ?>.</td>
				  <td><?php echo $row['year']; ?></td>
				  <td><?php echo $row['typename']; ?></td>
				  <td><?php echo $row['division']; ?></td>
				  <td><?php echo $row['pro_code']; ?></td>
				  <td><?php echo $row['pro_name']; ?></td>
				  <td><?php echo number_format($row['esti_amount'],2); ?></td>
				  <td><?php echo number_format($row['total_cost_esti'], 2); ?></td>
				  <td><?php echo $row['start_date']; ?></td>
				  <td><?php $st = $row['state']; $sql_st = mysqli_fetch_assoc(mysqli_query($conn, "SELECT status  FROM project_status WHERE id='$st'")); echo $sql_st['status']; ?></td> 
                </tr>
                <?php  } ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Footer -->
<?php include 'common/footer.php'; ?>
<!-- End Footer --> 

<!-- =========================================
JavaScript Files
========================================== --> 

<!-- jQuery JS --> 
<script src="js/assets/vendor/jquery-1.12.4.min.js"></script> 
<!-- Poppers Js --> 
<script src="js/assets/popper.js"></script> 
<!-- Bootstrap 
<script src="js/assets/bootstrap.min.js"></script> 
<!-- Sticky Js --> 
<script src="js/assets/jquery.sticky.js"></script> 
<!-- WOW JS --> 
<script src="js/assets/wow.min.js"></script> 
<!-- Smooth Scroll --> 
<script src="js/assets/smooth-scroll.js"></script> 
<!-- Mean Menu --> 
<script src="js/assets/jquery.meanmenu.min.js"></script> 
<!-- News Ticker --> 
<script src="js/assets/jquery.newsticker.min.js"></script> 
<!-- Owl Carousel --> 
<script src="js/assets/owl.carousel.min.js"></script> 
<!-- Magnific Popup --> 
<script src="js/assets/jquery.magnific-popup.min.js"></script> 
<!-- Syotimer --> 
<script src="js/assets/jquery.syotimer.min.js"></script> 
<!-- Custom JS --> 
<script src="js/plugins.js"></script> 
<script src="js/custom.js"></script> 

<!-- Bootstrap 3.3.5 --> 
<script src="backend/bootstrap/js/bootstrap.min.js"></script> 
<!-- DataTables --> 
<script src="backend/plugins/datatables/jquery.dataTables.min.js"></script> 
<script src="backend/plugins/datatables/dataTables.bootstrap.min.js"></script>
<script src='js/pdf_export/dataTables.buttons.min.js'></script> 
<script src='js/pdf_export/buttons.html5.min.js'></script> 
<script src='js/pdf_export/buttons.bootstrap.min.js'></script> 
<script src='js/pdf_export/jszip.min.js'></script> 
<script src='js/pdf_export/pdfmake.min.js'></script> 
<script src='js/pdf_export/vfs_fonts.js'></script> 
<script src="js/pdf_export/pdf_export_pro.js"></script> 

<script>
$(function () {
  $("#tabl_reg").DataTable();
});
  
function formHandler(id){
  window.location.href = 'project-list?type='+id;
}
</script>

</body>
</html>