<?php include "common/user_log.php";?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>NWP Engineering Department</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.5 -->
    <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="dist/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="dist/css/ionicons.min.css">
    <!-- daterange picker -->
    <link rel="stylesheet" href="plugins/daterangepicker/daterangepicker-bs3.css">
    <!-- iCheck for checkboxes and radio inputs -->
    <link rel="stylesheet" href="plugins/iCheck/all.css">
    <!-- Bootstrap Color Picker -->
    <link rel="stylesheet" href="plugins/colorpicker/bootstrap-colorpicker.min.css">
    <!-- Bootstrap time Picker -->
    <link rel="stylesheet" href="plugins/timepicker/bootstrap-timepicker.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="plugins/select2/select2.min.css">
	<!-- DataTables -->
    <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
         folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <link rel="stylesheet" href="bootstrap-sweetalert/lib/sweet-alert.css" />

<style>
.box-body h4 {
    font-size: 16px;
}
</style>

  </head>
  <body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">

      <header class="main-header">
        <!-- Logo -->
         <a href="home.php" class="logo">
          <!-- mini logo for sidebar mini 50x50 pixels -->
          <span class="logo-mini"><img src="img/logo.png" width="100"></span>
          <!-- logo for regular state and mobile devices -->
          <span class="logo-lg"><b><img src="img/logo.png" width="100"></b></span>
        </a>
        <!-- Header Navbar: style can be found in header.less -->
        <nav class="navbar navbar-static-top" role="navigation">
          <!-- Sidebar toggle button-->
          <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
            <span class="sr-only">Toggle navigation</span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
			 <span class="logo-lg">
             &nbsp;&nbsp;<font face="Lucida Sans Unicode, Lucida Grande, sans-serif">NWP Engineering Department</font></span>
          </a>
		
          <div class="navbar-custom-menu">
            <ul class="nav navbar-nav">

              <!-- User Account: style can be found in dropdown.less -->
              <li class="dropdown user user-menu">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                  <img src="dist/img/user2-160x160.png" class="user-image" alt="User Image">
                  <span class="hidden-xs"><?php echo $name; ?></span>
                </a>
                <ul class="dropdown-menu">
                  <!-- User image -->
                  <li class="user-header">
                    <img src="dist/img/user2-160x160.png" class="img-circle" alt="User Image">
                    <p>

                      NWP Engineering Department
                    
                    </p>
                  </li>
                  <!-- Menu Body -->
                 
                  <!-- Menu Footer-->
                  <li class="user-footer">
                    <div class="pull-left">
                      
                    </div>
                    <div class="pull-right">
                      <a href="distroy.php" class="btn btn-default btn-flat">Sign out</a>
                    </div>
                  </li>
                </ul>
              </li>
              <!-- Control Sidebar Toggle Button -->
              <li>
                <a href="#" data-toggle="control-sidebar"><i class="fa fa-gears"></i></a>
              </li>
            </ul>
          </div>
        </nav>
      </header>
      <!-- Left side column. contains the logo and sidebar -->
      <aside class="main-sidebar">
        <!-- sidebar: style can be found in sidebar.less -->
        <section class="sidebar">
          <!-- Sidebar user panel -->
    <?php include "common/sidebar.php"; ?>  
     
        </section>
        <!-- /.sidebar -->
      </aside>

      <!-- Content Wrapper. Contains page content -->
      <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>
            Project Invoice
          </h1>
    <ol class="breadcrumb">
      <li><a href="home.php"><i class="fa fa-home"></i> Home</a></li>
    </ol>
        </section>

        <!-- Main content -->
        <section class="content">

<!-- ************************************************* -->
<form id="form_invoice" action="javascript:void(0);" class="only_eng"> 
  
  <div class="box box-info only_eng"> 
    <div class="box-header with-border"> 
      <h4 class="box-title"> <a data-toggle="collapse" data-parent="#accordion" href="#inv">Project Invoice Details</a></h4>
    </div>
	
	<div id="inv" class="panel-collapse collapse in"> 	
	
    <div class="box-body"> 
    <div class="row"> 

      	<div class="form-group col-md-6"> 
      	  <label>Select Project:<font color="#FF0000"><strong>*</strong></font></label>
      	  <select class="form-control select2 project" id="project" name="project" style="width: 100%;" required>
      	  	<option value="">Select Project ...</option>
      		<?php
            $sql="SELECT * FROM projects_reg where id in (select project from aworded_contractors) ORDER BY pro_name ASC";
            $result=mysqli_query($conn, $sql);

            while ($row = mysqli_fetch_array($result)){

          ?>

            <option value="<?php echo $row['id']; ?>"><?php echo $row['pro_name']; ?></option>

          <?php } ?>
      	  </select>
      	</div>

      	<div class="form-group col-md-6"> 
      	  <label>Select Contractor:<font color="#FF0000"><strong>*</strong></font></label>
      	  <select class="form-control supplier" id="supplier" name="supplier" style="width: 100%;" required>
      	  	<option value="">Select Contractor ...</option>
      	  </select>
      	</div>
      </div>



        <div class="form-group"> 
          <label>Note:<font color="#FF0000"><strong>*</strong></font></label>
          <input type="text" class="form-control error" id="notes" name="notes" autocomplete="off" required>
        </div>

        <div class="form-group"> 
          <label>Description:<font color="#FF0000"><strong>*</strong></font></label>
          <textarea type="text" rows=3 class="form-control error" id="description" name="description" autocomplete="off" required></textarea>
        </div>

<div class="row"> 

        <div class="form-group col-md-6">
          <label>Date:<font color="#FF0000"><strong>*</strong></font></label>            
          <div class="input-group"> 
            <div class="input-group-addon"> <i class="fa fa-calendar"></i> </div>
            <input type="text" class="form-control pull-right" id="date" name="date" value="<?php echo date('Y-m-d'); ?>" autocomplete="off" required>
          </div>
        </div>
		        <div class="form-group col-md-6">
          <label>Current Progress (%):<font color="#FF0000"><strong>*</strong></font></label>
          <input type="text" class="form-control error" id="progress" name="progress" autocomplete="off" required>
        </div>
        </div>


    </div>	
    </div>	
  </div>
  
			 <div class="panel box box-info only_eng"> 
                <div class="box-header with-border"> 
                  <h4 class="box-title"> <a data-toggle="collapse" data-parent="#accordion" href="#pass"> 
                 Payment Details</a> </h4>
                </div>
                <div id="pass" class="panel-collapse collapse in"> 
                  <div class="box-body"> 
				  
				  <h4><b>Allocation Amount: &nbsp;Rs. <span id="allocation_txt">0.00</span></b></h4>
				  <h4>Contract Amount: &nbsp;Rs. <span id="con_amount_txt">0.00</span></h4>
				  <h4>Pro. Sum: &nbsp;Rs. <span id="pro_sum_txt">0.00</span></h4>
			  <hr>
				<div class="form-group">
				  <label>Payment Type:<font color="#FF0000"><strong>*</strong></font></label>
				  <select class="form-control" id="pay_type" name="pay_type" style="width: 100%;" required>
					<option value="">Select Payment Type...</option>
					<option value="1" id="adv">Advance Payment</option>
					<option value="2" id="partp">Part Payment</option>
					<option value="3" id="finalp">Retention Payment</option>
				  </select>
				</div>			
				
				<div id="adv_pay" style="display:none">
					<div class="form-group">
					  <label>Contract Amount:<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clrp" id="con_amount" name="con_amount" autocomplete="off" readonly>
					</div>
					
					<div class="form-group">
					  <label>Pro. Sum (Total):<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clrp" id="pro_sum" name="pro_sum" autocomplete="off" readonly>
					</div>
					
					<div class="form-group">
					  <label>Project Value:<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clrp" id="pro_val" name="pro_val" autocomplete="off" readonly>
					</div>
					
					<div class="form-group">
					  <label>Advance (%):<font color="#FF0000"><strong>*</strong></font></label>
					 <input type="text" class="form-control clr" id="adv_max" name="adv_max" autocomplete="off">
					  <p class="help-block">Max: 30%</p> <input type="hidden" class="form-control clr" id="adv_payment" name="adv_payment" autocomplete="off" readonly>
					</div>

					<div class="row" id="adv_vat_reg" style="display:none">
						<div class="form-group"> 
							<label for="" class="col-sm-2 col-md-1 col-xs-4 control-label" style="padding-top: 7px;">Add VAT:</label>
							<div class="col-sm-2 col-xs-4 col-md-1"> 
							  <input type="text" class="form-control clr" id="adv_vat" name="adv_vat" autocomplete="off">
							</div>
							<label for="" class="col-sm-1 col-md-1 col-xs-2 control-label" style="padding-top: 7px; padding-left: 0;">% :</label>
							<div class="col-sm-3 col-xs-12"> 
							  <input type="text" class="form-control clr" id="adv_vat_val" name="adv_vat_val" autocomplete="off" readonly>
							</div>
						</div><br><br>
					</div>
					
					<div class="form-group">
					  <label>Total Advance Payment:<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clr" id="adv_payment_val" name="adv_payment_val" autocomplete="off" readonly>
					</div>
				</div>
				
				
				<div id="part_pay" style="display:none">
					<div class="form-group">
					  <label>Gross Amount:<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clrp" id="gross_amount" name="gross_amount" autocomplete="off">
					</div>
					
					<div class="form-group">
					  <label>Previous Gross Amount:<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clrp" id="prv_gross_amount" name="prv_gross_amount" value="0" autocomplete="off" readonly>
					</div>
					
					<div class="form-group">
					  <label>Gross Amount Payable:<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clrp" id="gross_amount_pay" name="gross_amount_pay" autocomplete="off" readonly>
					</div>
					
					<div class="row">
						<div class="form-group"> 
							<label for="" class="col-sm-12 col-md-2 col-xs-12 control-label" style="padding-top: 7px;">Less - Retention <br>(With VAT):<font color="#FF0000"><strong>*</strong></font></label>
							<div class="col-sm-2 col-xs-4 col-md-1" style="padding-left: 0px;"> 
							  <input type="text" class="form-control clr clr3" id="less_reten" name="less_reten" autocomplete="off">
							  <input type="hidden" class="form-control clr clr3" id="less_reten_vat"  autocomplete="off" readonly>
							</div>
							<label for="" class="col-sm-1 col-md-1 col-xs-2 control-label" style="padding-top: 7px; padding-left: 0;">% :</label>
							<div class="col-sm-3 col-xs-12"> 
							  <input type="text" class="form-control clr clr3" id="less_reten_val" name="less_reten_val" autocomplete="off" readonly>
							</div>
							
							<label for="" class="col-sm-1 col-md-3 col-xs-6 control-label" style="padding-top: 7px; padding-left: 0;">Total Retention Recovery:</label> <!-- Without VAT -->
							<div class="col-sm-2 col-xs-12"> 
							  <input type="hidden" class="form-control clr clr3" id="max_reten" name="max_reten" autocomplete="off" readonly title="Max Retention Value">
							  <input type="text" class="form-control clr clr3" id="tot_reten_val" name="tot_reten_val" autocomplete="off" readonly>
							</div>
						</div>
					</div><br>
					
					<div class="form-group">
					  <label>Balance:<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clr clr3" id="balance_1" name="balance_1" autocomplete="off" readonly>
					</div>
					
					<div class="form-group">
					  <label>Less - Advance Payment:<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clr clr3" id="less_adv_pay" name="less_adv_pay" autocomplete="off" readonly>
					</div>
					
					<div class="form-group">
					  <label>Balance:<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clr clr3" id="balance_2" name="balance_2" autocomplete="off" readonly>
					</div>
					
					<div class="row">
						<div class="form-group"> 
							<label for="" class="col-sm-12 col-md-2 col-xs-12 control-label" style="padding-top: 7px;">Less - LD:<font color="#FF0000"><strong>*</strong></font></label>
							<div class="col-sm-2 col-xs-4 col-md-2" style="padding-left: 0px;"> 
							  <input type="text" class="form-control clr clr4" id="less_LD" name="less_LD" autocomplete="off">
							</div>
							
							<div class="col-sm-3 col-xs-12"> 
							  <input type="text" class="form-control clr clr4" id="less_LD_val" name="less_LD_val" autocomplete="off" readonly>
							</div>
							
							<div class="col-sm-3 col-xs-12"> 
							  <input type="hidden" class="form-control clr clr4" id="less_LD_max" name="less_LD_max" autocomplete="off" readonly>
							</div>
						</div>
					</div><br>
					
					<div class="form-group">
					  <label>Net Amount Payable:<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clr clr4" id="net_amount_pay" name="net_amount_pay" autocomplete="off" readonly>
					</div>
					
					<div class="row vat form-group">
						<div class=""> 
							<label for="" class="col-sm-2 col-md-1 col-xs-4 control-label" style="padding-top: 7px;">Add VAT:</label>
							<div class="col-sm-2 col-xs-4 col-md-1"> 
							  <input type="text" class="form-control clr" id="vat" name="vat" autocomplete="off">
							</div>
							<label for="" class="col-sm-1 col-md-1 col-xs-2 control-label" style="padding-top: 7px; padding-left: 0;">% :</label>
							<div class="col-sm-3 col-xs-12"> 
							  <input type="text" class="form-control clr clr5" id="vat_val" name="vat_val" autocomplete="off" readonly>
							  <input type="hidden" class="form-control clrp" id="vat_reg" name="vat_reg" readonly>
							</div>
						</div>
					</div>
					
					<div class="form-group">
					  <label>Amount to be paid:<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clr clr5" id="paid_amount" name="paid_amount" autocomplete="off" readonly>
					</div>
					
					<!--
					<div class="form-group">
					  <label>Less - W.H.T:<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="hidden" class="form-control clr" id="less_WHT" name="less_WHT" value='0' autocomplete="off" readonly>
					</div>
					
					<div class="form-group">
					  <label>Retention (Deposit):<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clr" id="retention" name="retention" autocomplete="off" readonly>
					</div>
					
					<div class="form-group vat">
					  <label>VAT for Retention:<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clr" id="vat_retention" name="vat_retention" autocomplete="off" readonly>
					</div>
					
					<div class="form-group">
					  <label>Total Payment:<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clr" id="tot_pay" name="tot_pay" autocomplete="off" readonly>
					</div>-->
				
					<input type="hidden" class="form-control clrp" id="tot_payment" name="tot_payment" readonly>
					<input type="hidden" class="form-control clrp" id="tot_reten" name="tot_reten" readonly>

				</div>
				
				<div id="final_pay" style="display:none">
					<div class="form-group">
					  <label>Retention (Deposit):<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clr" id="retentiond" name="retentiond" autocomplete="off" readonly>
					</div>
					
					<div class="row vatfinal form-group"><br>
						<div class=""> 
							<label for="" class="col-sm-2 col-md-2 col-xs-4 control-label" style="padding-top: 7px;">VAT for Retention:<font color="#FF0000"><strong>*</strong></font></label>
							<div class="col-sm-2 col-xs-4 col-md-1"> 
							  <input type="text" class="form-control clr" id="vatfinal" name="vatfinal" autocomplete="off">
							</div>
							<label for="" class="col-sm-1 col-md-2 col-xs-2 control-label" style="padding-top: 7px; padding-left: 0;">% :</label>
							<div class="col-sm-3 col-xs-12"> 
							  <input type="text" class="form-control clr" id="vat_retenf" name="vat_retenf" autocomplete="off" readonly>
							</div>
						</div><br><br>
					</div>
				
					<div class="form-group">
					  <label>Total Payment:<font color="#FF0000"><strong>*</strong></font></label>
					  <input type="text" class="form-control clr" id="tot_payf" name="tot_payf" autocomplete="off" readonly>
					</div>
					
					
				</div>
				
			   </div>
			   
                </div>
              </div>  
          
		  <input type="hidden" class="form-control clrp" id="pub_supp" name="pub_supp">

        <div class="box-footer"><span style="color: red;" class="pull-right">* Required Fields</span>
          <button class="btn btn-primary">SUBMIT</button>
        </div>
		
      </form>		
		
<br>
 <!-- /.table -->
        
    <div class="box box-info"> 
      <div class="box-header"> 
        <h3 class="box-title">Invoices</h3>
      </div>
      <!-- /.box-header -->
      <div class="box-body table-responsive"> 
        <table id="example1" class="table table-bordered table-striped">
          <thead>
            <tr>
            	<th>ID</th>
            	<th>Invoice Date</th>
            	<th>Project</th>
            	<th>Supplier</th>
              <th>Payment Type</th>
				<th> Invoice No</th>
              <th>Project Value</th>
              <th>Paid Amount</th>
				<th>View Invoice</th>
      				<!--<th class="only_eng">Edit</th>-->
      				<th class="only_eng">Remove Invoice</th>
            </tr>
          </thead>
          <tbody>
            <?php 
             $sql="SELECT
contractor_reg.name,
projects_reg.pro_name,
project_invoice.id,
project_invoice.project,
project_invoice.supplier,
project_invoice.pub_supplier,
project_invoice.`date`,
project_invoice.payment_type,
project_invoice.pro_val,
project_invoice.invoice_no,
project_invoice.tot_pay
FROM
project_invoice
Inner Join projects_reg ON project_invoice.project = projects_reg.id
Inner Join contractor_reg ON project_invoice.supplier = contractor_reg.id WHERE flag = '0'
ORDER BY project_invoice.id DESC";

              $result=mysqli_query($conn, $sql);
              $x = 0;
              while ($row = mysqli_fetch_array($result)){ $x++;
            ?>

            <tr>
              <td><?php echo $x; ?>.</td>
              <td><?php echo $row['date']; ?></td>
              <td><?php echo $row['pro_name']; ?></td>
              <td><?php echo $row['name']; if(!empty($row['pub_supplier'])) {echo ' - '.$row['pub_supplier'];} ?></td>
              <td><?php echo $row['payment_type']; ?></td>
              <td><?php echo $row['invoice_no']; ?></td>
              <td align="right"><?php echo number_format($row['pro_val'], 2); ?></td>
              <td align="right"><?php echo number_format($row['tot_pay'], 2); ?></td>
                  
              <td align="center">
      			     <a  class="btn btn-info btn-sm" href="view_invoice.php?id=<?php echo $row['id']; ?>" target="_blank"><span class="glyphicon glyphicon-search"></span> </a>
      			  </td>
              
             <!-- <td align="center" class="only_eng">
      			     <button  class="btn btn-info btn-sm btn_up" data-toggle="modal" data-target="#edit_lng" value="<?php //echo $row['id']; ?>"><span class="glyphicon glyphicon-pencil"></span> &nbsp;EDIT </button>
      			  </td>-->
              <td align="center" class="only_eng">
                  <button value="<?php echo $row['id']; ?>" data-pid="<?php echo $row['project']; ?>" class="btn btn-danger btn-sm btn_dell">
                <span class="glyphicon glyphicon-trash"></span> </button>
              </td> 
            </tr>
            <?php  } ?>
          </tbody>
        </table>
      </div>
      <!-- /.box-body -->
    </div>
    
  </section>
   
      </div>
	      <!-- /.End table -->
<!-- ************************************************* -->
      
           <!-- /.col -->
              </div><!-- /.row -->
            </div><!-- /.box-body -->
            
          

          <div class="row">
            
    
    
      </div>
      <!-- /.col (right) -->
         

      </div>
<footer class="main-footer"> 
  <div class="pull-right hidden-xs">
  </div><strong>Copyright &copy; NWP Engineering Department</strong> All rights reserved.
</footer>

      <!-- Control Sidebar -->
      <aside class="control-sidebar control-sidebar-dark">
        <!-- Create the tabs -->
        <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
          <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>
          <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
        </ul>
        <!-- Tab panes -->
        <div class="tab-content">
          <!-- Home tab content -->
          <div class="tab-pane" id="control-sidebar-home-tab">
          </div><!-- /.tab-pane -->

          </div><!-- /.tab-pane -->
        </div>
      </aside><!-- /.control-sidebar -->
      <!-- Add the sidebar's background. This div must be placed
           immediately after the control sidebar -->
      <div class="control-sidebar-bg"></div>
    </div><!-- ./wrapper -->

<!-- Modal -->
  <div class="modal fade" id="edit_prosum" role="dialog">
    <div class="modal-dialog">
    
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title" id="test_id"></h4>
        </div>
        <div class="modal-body">

          <form id="form_prosum_up" action="javascript:void(0);">  
            <div class="form-group"> 
              <label>Pro. Sum:<font color="#FF0000"><strong>*</strong></font></label>
              <input type="text" class="form-control error" id="prosum_up" name="prosum_up" autofocus autocomplete="off" value=0 required>
            </div>
            <span style="color: red;" class="pull-right">* Required Fields</span>

            <div class="box-footer">
              <input type="hidden" name="pro_id" id="pro_id">
              <input type="hidden" name="sup_id" id="sup_id">
              <button class="btn btn-primary">SUBMIT</button>
            </div>
          </form>

        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>


    <!-- jQuery 2.1.4 -->
    <script src="plugins/jQuery/jQuery-2.1.4.min.js"></script>
    <!-- Bootstrap 3.3.5 -->
    <script src="bootstrap/js/bootstrap.min.js"></script>
    <!-- Select2 -->
    <script src="plugins/select2/select2.full.min.js"></script>
	<!-- DataTables -->
    <script src="plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
    <!-- InputMask -->
    <script src="plugins/input-mask/jquery.inputmask.js"></script>
    <script src="plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
    <script src="plugins/input-mask/jquery.inputmask.extensions.js"></script>
    <!-- date-range-picker -->
    <script src="plugins/daterangepicker/moment.min.js"></script>
    <script src="plugins/daterangepicker/daterangepicker.js"></script>
    <!-- bootstrap color picker -->
    <script src="plugins/colorpicker/bootstrap-colorpicker.min.js"></script>
    <!-- bootstrap time picker -->
    <script src="plugins/timepicker/bootstrap-timepicker.min.js"></script>
    <!-- SlimScroll 1.3.0 -->
    <script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
    <!-- iCheck 1.0.1 -->
    <script src="plugins/iCheck/icheck.min.js"></script>
    <!-- FastClick -->
    <script src="plugins/fastclick/fastclick.min.js"></script>
    <!-- AdminLTE App -->
    <script src="dist/js/app.min.js"></script>
    <!-- AdminLTE for demo purposes -->
    <script src="dist/js/demo.js"></script>
    <script src="bootstrap-sweetalert/lib/sweet-alert.min.js"></script>
	
    <!-- Page script -->
    <script>
      $(function () {
        //Initialize Select2 Elements
        $(".select2").select2();

        //Datemask dd/mm/yyyy
        $("#datemask").inputmask("dd/mm/yyyy", {"placeholder": "yyyy-mm-dd"});
        //Datemask2 mm/dd/yyyy
        $("#datemask2").inputmask("mm/dd/yyyy", {"placeholder": "yyyy-mm-dd"});
        //Money Euro
        $("[data-mask]").inputmask();

        //Date range picker
        $('#reservation').daterangepicker();
        //Date range picker with time picker

       $('#date').daterangepicker({timePicker: false, timePickerIncrement: 30, format: 'YYYY-MM-DD'});
       $('#date_up').daterangepicker({timePicker: false, timePickerIncrement: 30, format: 'YYYY-MM-DD'});

        //Date range as a button
        $('#daterange-btn').daterangepicker(
            {
              ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month')]
              },
              startDate: moment().subtract(29, 'days'),
           
            },
        function (start) {
          $('#reportrange span').html(start.format('MMMM D, YYYY'));
        }
        );

        //iCheck for checkbox and radio inputs
        $('input[type="checkbox"].minimal, input[type="radio"].minimal').iCheck({
          checkboxClass: 'icheckbox_minimal-blue',
          radioClass: 'iradio_minimal-blue'
        });
        //Red color scheme for iCheck
        $('input[type="checkbox"].minimal-red, input[type="radio"].minimal-red').iCheck({
          checkboxClass: 'icheckbox_minimal-red',
          radioClass: 'iradio_minimal-red'
        });
        //Flat red color scheme for iCheck
        $('input[type="checkbox"].flat-red, input[type="radio"].flat-red').iCheck({
          checkboxClass: 'icheckbox_flat-green',
          radioClass: 'iradio_flat-green'
        });

        
      });
	  
      $(function () {
        $("#example1").DataTable();
        $('#example2').DataTable({
          "paging": true,
          "lengthChange": false,
          "searching": false,
          "ordering": true,
          "info": true,
          "autoWidth": false
        });
      });
	  

$('#project').change(function () {
	var id = $(this).val();
	load_supplier(id);
	hidePaymentsDiv();
});

function load_supplier(id) {
  $.post('function/contractors_conn.php', {'get_supplier': 'data', id: id}, function (data) {
	  $("#supplier").html(data);
  });
}

$('#supplier').change(function () {
	var supplier = $(this).val();
	var pid = $('#project').val();
	
	hidePaymentsDiv();
	clear2();
	
	if(pid != '' && supplier != '') {
		load_sup_details(pid, supplier);
	}
});

function load_sup_details(pid, supplier, model = 0) {
	$.post('function/contractors_conn.php', {'get_sup_details': 'data', pid: pid, supplier: supplier}, function (data) {
		if(data.length === 0) {

		} else {
			if(data.count === 0) {
				$('#adv').show();

			} else {
				$('#adv').hide();
			}
			
			if(data.countp === 0 && model === 0) {
				$('#pro_id').val(pid);
				$('#sup_id').val(supplier);
				$('#edit_prosum').modal('show');
				$('#prosum_up').focus();
			}
			
			var gross_amount = (data.c_amount - data.pro_sum) - data.prevGross_tot;

			$('#gross_amount').val(gross_amount.toFixed(2));
			$('#con_amount').val(data.c_amount);
			$('#con_amount_txt').text(data.c_amount);
			$('#allocation_txt').text(data.allocation_tot);
			$("#pub_supp").val(data.pub_supp);
			$("#vat_reg").val(data.vat_reg);
			$('#pro_sum_txt').text(data.pro_sum);
			$('#pro_sum').val(data.pro_sum);
			$('#prosum_up').val(data.pro_sum);
			$('#pro_val').val(data.pro_val.toFixed(2));
			$('#tot_payment').val(data.tot_payment);
			$('#prv_gross_amount').val(data.prevGross);
			$('#gross_amount_pay').val(gross_amount.toFixed(2));
			$('#tot_reten').val(data.tot_reten);
		}
		
	}, "json");
}

$('#pay_type').change(function () {
	clear();
	var id = $(this).val();
	var supplier = $('#supplier').val();
	var pid = $('#project').val();	
	var con_amount = $('#con_amount').val();	
	
	if(supplier === '' || pid === '' || con_amount <= 0) {
		hidePaymentsDiv();
	
	} else {
		var vat_reg = $('#vat_reg').val();
		if(id === '1') { // Advance Payment
			$('#adv_pay').show();
			$('#part_pay').hide();
			$('#final_pay').hide();
			
			if(vat_reg === '1') {
				$("#adv_vat").val('8');
				$("#adv_vat_val").val('');
				$('#adv_vat_reg').show();

			} else {
				$("#adv_vat").val('0');
				$("#adv_vat_val").val('0');
				$('#adv_vat_reg').hide();
			}
		
		} else if(id === '2') { // Part Payment
			$('#adv_pay').hide();
			$('#part_pay').show();
			$('#final_pay').hide();
			
			if(vat_reg === '1') {
				$("#vat").val('8');
				$("#vat_val").val('');
				$('.vat').show();

			} else {
				$("#vat").val('0');
				$("#vat_val").val('0');
				$('.vat').hide();
			}
			
			$('#gross_amount').focus();
		
		} else if(id === '3') { // Final Payment
			$('#adv_pay').hide();
			$('#part_pay').hide();
			$('#final_pay').show();

			if(vat_reg === '1') {
				$("#vatfinal").val('8');
				$("#vat_retenf").val('');
				$('.vatfinal').show();

			} else {
				$("#vatfinal").val('0');
				$("#vat_retenf").val('0');
				$('.vatfinal').hide();
			}
			
			calFinalPayment();
		
		} else {
			$('#adv_pay').hide();
			$('#part_pay').hide();
			$('#final_pay').hide();
		}
	}
});

function hidePaymentsDiv() {
	clear();
	$('#adv_pay').hide();
	$('#part_pay').hide();
	$('#final_pay').hide();
	$('#pay_type').val('');
	$('#adv').show();
	$('#con_amount_txt').text('0.00');
	$('#allocation_txt').text('0.00');
	$('#pro_sum_txt').text('0.00');
}

function clear() {
	$('.clr').val('');
}

function clear2() {
	$('.clrp').val('');
}

function errorAdv() {
	$("#adv_vat_val").val('');
	$("#adv_payment_val").val('');
	$("#adv_payment").val('');
	
	swal({
	  title: "",
	  text: "Advance value should be 30% or 20%",
	  type: "error",
	  timer: 2000,
	  showConfirmButton: false,
	});
	
	$("#adv_max").focus();
}

$("#adv_max").focusout(function () {
	var pro_val = $("#pro_val").val();
	
	if(pro_val > 0) {
		calAdvancedPayment();
	
	} else {
		$("#adv_payment_val").val('');
	}
});

$("#adv_vat").keyup(function () {
	var adv_max = $("#adv_max").val();
	if(adv_max > 0) {
		calAdvancedVAT();
	
	} else {
		$(this).val(8);
	}
});

function calAdvancedPayment() {
	var adv = $("#adv_max").val();
	var pro_val = $("#pro_val").val();
	
	if($.isNumeric(adv)) {
		if(adv == 20 || adv == 30) {
			var adv_vat = $("#adv_vat").val();
			
			var adv_val = (pro_val * adv)/100;
			var adv_vat_val = (adv_val * adv_vat)/100;
			
			if((adv_val + adv_vat_val) >= pro_val) {
				errorAdv();
			
			} else {
				$('#adv_payment').val(adv_val.toFixed(2));
				$('#adv_vat_val').val(adv_vat_val.toFixed(2));
				$('#adv_payment_val').val((adv_val+adv_vat_val).toFixed(2));
			}
		
		} else {
			errorAdv();
		}
	
	} else {
		errorAdv();
	}
}

function calAdvancedVAT() { 
	var adv_payment = $("#adv_payment").val();
	var vat = $("#adv_vat").val();
	
	if($.isNumeric(vat)) {
		if(vat <= 0 || vat > 15) {
			$("#adv_vat").val('8');
			
			swal({
			  title: "",
			  text: "Invalid VAT Value!",
			  type: "error",
			  timer: 2000,
			  showConfirmButton: false,
			});
			
			$("#adv_vat").focus();
		}
	
	} else {
		$("#adv_vat").val('8');
		
		swal({
		  title: "",
		  text: "Invalid VAT Value!",
		  type: "error",
		  timer: 2000,
		  showConfirmButton: false,
		});
		
		$("#adv_vat").focus();
	}
		
	if(adv_payment > 0) {
		var vat = $("#adv_vat").val();
		var vat_val = (adv_payment * vat)/100;
		$('#adv_vat_val').val(vat_val.toFixed(2));
		
		var paid_tot = parseFloat(adv_payment) + parseFloat(vat_val);
		$('#adv_payment_val').val(paid_tot.toFixed(2));
	}
}

function calFinalPayment() {
	var pro_val = $("#pro_val").val();
	var vat = $("#vatfinal").val();
	
	var retdeposit = (pro_val * 5)/100;
	var retvat = (retdeposit * vat)/100;
	var totdeposit = retdeposit + retvat;
	
	$('#retentiond').val(retdeposit.toFixed(2))
	$('#vat_retenf').val(retvat.toFixed(2))
	$('#tot_payf').val(totdeposit.toFixed(2))

}

$("#vatfinal").keyup(function () {
	var retentiond = $("#retentiond").val();
	if(retentiond > 0) {
		calFinalVAT();
	
	} else {
		$(this).val(8);
	}
});

function calFinalVAT() {
	var retentiond = $("#retentiond").val();
	var vat = $("#vatfinal").val();
	
	if($.isNumeric(vat)) {
		if(vat <= 0 || vat > 15) {
			$("#vatfinal").val('8');
			
			swal({
			  title: "",
			  text: "Invalid VAT Value!",
			  type: "error",
			  timer: 2000,
			  showConfirmButton: false,
			});
			
			$("#vatfinal").focus();
		}
	
	} else {
		$("#vatfinal").val('8');
		
		swal({
		  title: "",
		  text: "Invalid VAT Value!",
		  type: "error",
		  timer: 2000,
		  showConfirmButton: false,
		});
		
		$("#vatfinal").focus();
	}
		
	if(retentiond > 0) {
		var vat = $("#vatfinal").val();
		var vat_val = (retentiond * vat)/100;
		$('#vat_retenf').val(vat_val.toFixed(2));
		
		var paid_tot = parseFloat(retentiond) + parseFloat(vat_val);
		$('#tot_payf').val(paid_tot.toFixed(2));
	}
}

$("#gross_amount").keyup(function () {
	clear3();
	var gross_amount = parseFloat($(this).val());
	var grossPayble = parseFloat($("#gross_amount_pay").val());
	
	if($.isNumeric(gross_amount)) {
		if(gross_amount > 0 && gross_amount <= grossPayble) {
		
		} else {
			swal({
			  title: "",
			  text: "Invalid Gross Amount!",
			  type: "error",
			  timer: 2000,
			  showConfirmButton: false,
			});
			clear3();
			$(this).val('');
		}
	
	} else {
		clear3();
		$(this).val('');
	}
});

$("#less_reten").keyup(function () {
	clear4();
	var gross_amount = parseFloat($("#gross_amount").val());
	if(gross_amount > 0) {
		calRetention();
	}
});

function calRetention() {
	var lret = parseFloat($("#less_reten").val());
	var pro_val = parseFloat($("#pro_val").val());
	var grossPayble = parseFloat($("#gross_amount_pay").val());
	var tot_ret = parseFloat($("#tot_reten").val());
	var gross_amount = $("#gross_amount").val();
	
	if($.isNumeric(lret)) {
		if(lret >= 0 && lret <= 10) {
			var max_ret = (pro_val * lret)/100;
			var ret_val = (grossPayble * lret)/100;
			
			if(ret_val < 0 || ret_val > max_ret) {
				swal({
				  title: "",
				  text: "Invalid Retention Value!",
				  type: "error",
				  timer: 2000,
				  showConfirmButton: false,
				});
				clear3();
			
			} else {
				if(ret_val >= gross_amount) {
					$("#gross_amount").focus();
					swal({
					  title: "",
					  text: "Invalid Gross Amount!",
					  type: "error",
					  timer: 2000,
					  showConfirmButton: false,
					});
					clear3();
					
				} else {
					var ret_cal = ((tot_ret + ret_val) * 100) / pro_val;
					
					$("#less_reten_val").val(ret_val.toFixed(2));
					$("#max_reten").val(max_ret.toFixed(2));
					$("#tot_reten_val").val(ret_cal.toFixed(2)+' %');
					
					var bal1 = gross_amount - ret_val;
					$('#balance_1').val(bal1.toFixed(2));

					var less_adv = parseFloat((bal1 * 2) / 9);
					$('#less_adv_pay').val(less_adv.toFixed(2));

					var bal2 = parseFloat(bal1 - less_adv);
					$('#balance_2').val(bal2.toFixed(2));
					
					/*var vat_reg = $("#vat_reg").val();
					if(vat_reg === '1') {
						$("#less_reten").val(lret+8)
					}*/
				}
			}
		
		} else {
			swal({
			  title: "",
			  text: "Invalid Retention Value!",
			  type: "error",
			  timer: 2000,
			  showConfirmButton: false,
			});
			clear3();
		}
	
	} else {
		swal({
		  title: "",
		  text: "Invalid Retention Value!",
		  type: "error",
		  timer: 2000,
		  showConfirmButton: false,
		});
		clear3();
	}
}

$("#less_LD").keyup(function () {
	clear5();
	var balance_2 = $("#balance_2").val();
	if(balance_2 > 0) {
		cal_LD();
	}
});

function cal_LD() {
	var less_LD = $("#less_LD").val();
	if($.isNumeric(less_LD)) {
		if(less_LD >= 0) {
			var pro_val = $("#pro_val").val();
			var gross_amount = $("#gross_amount").val();
			var bal2 = $("#balance_2").val();
			
			var lessLD = (pro_val * less_LD)/2000;
			var net_amt = bal2-lessLD;
			
			var max_LD = (lessLD * 100)/gross_amount;

			if(net_amt <= 0 || max_LD > 5) {
				swal({
				  title: "",
				  text: "Invalid Less - LD Value!",
				  type: "error",
				  timer: 2000,
				  showConfirmButton: false,
				});
				clear4();
			
			} else {
				$('#less_LD_val').val(lessLD.toFixed(2));
				$('#less_LD_max').val(max_LD.toFixed(2));
				$('#net_amount_pay').val(net_amt.toFixed(2));
				
				var vat_reg = $("#vat_reg").val();
				if(vat_reg === '1') {
					calVAT();
				
				} else {
					$("#paid_amount").val(net_amt.toFixed(2));
				}
			}

		} else {
			swal({
			  title: "",
			  text: "Invalid Less - LD Value!",
			  type: "error",
			  timer: 2000,
			  showConfirmButton: false,
			});
			clear4();
		}
	
	} else {
		swal({
		  title: "",
		  text: "Invalid Less - LD Value!",
		  type: "error",
		  timer: 2000,
		  showConfirmButton: false,
		});
		clear4();
	}
}

$("#vat").keyup(function () {
	var net_amount_pay = $("#net_amount_pay").val();
	if(net_amount_pay > 0) {
		calVAT();
	
	} else {
		$(this).val(8);
	}
});

function calVAT() {
	var net_amount_pay = $("#net_amount_pay").val();
	var vat = $("#vat").val();
	
	if($.isNumeric(vat)) {
		if(vat <= 0 || vat > 15) {
			$("#vat").val('8');
			
			swal({
			  title: "",
			  text: "Invalid VAT Value!",
			  type: "error",
			  timer: 2000,
			  showConfirmButton: false,
			});
			
			clear5();
		}
	
	} else {
		$("#vat").val('8');
		
		swal({
		  title: "",
		  text: "Invalid VAT Value!",
		  type: "error",
		  timer: 2000,
		  showConfirmButton: false,
		});
		
		clear5();
	}
		
	if(net_amount_pay > 0) {
		var vat = $("#vat").val();
		var vat_val = (net_amount_pay * vat)/100;
		$('#vat_val').val(vat_val.toFixed(2));
		
		var paid_tot = parseFloat(net_amount_pay) + parseFloat(vat_val);
		$('#paid_amount').val(paid_tot.toFixed(2));
	}
}

function clear3() {
	$('.clr3').val('');
	clear4();
}

function clear4() {
	$('.clr4').val('');
	clear5();
}

function clear5() {
	$('.clr5').val('');
}

$("#form_prosum_up").on('submit',(function(e) {
    e.preventDefault();
    $.ajax({
    url: "function/project_invoice_fun.php",
    type: "POST",
    data:  new FormData(this),
    contentType: false,
        cache: false,
    processData:false,
    success: function(data){
      if(data.status == 'ok') {		
		swal({
		  title: "",
		  text: "Successfully Updated!",
		  type: "success",
		  timer: 1000,
		  showConfirmButton: false,
		});
		
		$( '.modal' ).modal( 'hide' ).data( 'bs.modal', null );
		var pid = $('#pro_id').val();
	    var supplier = $('#sup_id').val();
        load_sup_details(pid, supplier, 1);

      } else if(data.status == 'error4') {
        swal("", "Invalid Pro Sum!", "warning");
     
 	  } else {
        swal("Oops...", "Something went wrong!", "warning");
      }
      
    },
    error: function(e) {
        alert("err2");
    }
   });
}));

$("#form_invoice").on('submit',(function(e) {
    e.preventDefault();
    $.ajax({
    url: "function/project_invoice_fun.php",
    type: "POST",
    data:  new FormData(this),
    contentType: false,
        cache: false,
    processData:false,
    success: function(data){
      if(data.status == 'ok') {
        swal({
          title: "",
          text: "Successfully Added!",
          type: "success",
          confirmButtonText: "OK"
            },
            function (isConfirm) {
          if (isConfirm) {
              window.location.href = "project_invoice.php";
          }
        });
      
	  } else if(data.status == 'error2') {
		  swal("", "Invalid Advance Payment!", "warning");
	  
	  } else if(data.status == 'error6') {
		  swal("", "Invalid Retention Payment!", "warning");
	  
	  } else if(data.status == 'error3') {
		  swal("", "Please Enter Required Fields!", "warning");
	  
	  } else {
        swal("Oops...", "Something went wrong!", "warning");
      }
      
    },
    error: function(e) {
        alert("error");
    }
   });
}));

$(".btn_dell").click(function(){
  var x = $(this).val();
  var pid = $(this).attr('data-pid');
 
 swal({
	title: "",
	text: "Are you sure you want to delete this invoice?",
	type: "warning",
	showCancelButton: true,
	confirmButtonClass: "btn-danger",
	confirmButtonText: "Yes, delete it!",
	closeOnConfirm: false
  },
	function () {
	  del_func(x, pid);
	}
  );
});

function del_func(reg_id, pid){
	if(reg_id === '' || pid === '') {
		swal("Warning!", "Please Select Valid Record!", "warning");
	
	} else {
		$.post( "function/project_invoice_fun.php", {remove_reg: "data", reg_id : reg_id, pid : pid}, function( data ) {
		    if (data.status == 'ok') {
			  swal({
				title: "",
				text: "Successfully Deleted!",
				type: "success",
				confirmButtonText: "OK"
			  },

			  function (isConfirm) {            
  				if (isConfirm) {
  					window.location.href = "project_invoice.php";
  				}
			  });
			
			} else {
			  swal("Oops...", "Something went wrong!", "warning");
			}
		}, "json");
	}
}
</script>
</body>
</html>